/*
 * Decompiled with CFR 0.152.
 */
package andrews.table_top_craft.game_logic.chess.board.moves;

import andrews.table_top_craft.game_logic.chess.board.Board;
import andrews.table_top_craft.game_logic.chess.board.BoardUtils;
import andrews.table_top_craft.game_logic.chess.board.moves.BaseMove;
import andrews.table_top_craft.game_logic.chess.pieces.BasePiece;
import andrews.table_top_craft.game_logic.chess.pieces.PawnPiece;

public class PawnPromotion
extends BaseMove {
    final BaseMove decoratedMove;
    final PawnPiece promotedPawn;

    public PawnPromotion(BaseMove decoratedMove) {
        super(decoratedMove.getBoard(), decoratedMove.getMovedPiece(), decoratedMove.getDestinationCoordinate());
        this.decoratedMove = decoratedMove;
        this.promotedPawn = (PawnPiece)decoratedMove.getMovedPiece();
    }

    @Override
    public int hashCode() {
        return this.decoratedMove.hashCode() + 31 * this.promotedPawn.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        return this == object || object instanceof PawnPromotion && super.equals(object);
    }

    @Override
    public Board execute() {
        Board pawnMoveBoard = this.decoratedMove.execute();
        Board.Builder builder = new Board.Builder();
        for (BasePiece piece : pawnMoveBoard.getCurrentChessPlayer().getActivePieces()) {
            if (this.promotedPawn.equals(piece)) continue;
            builder.setPiece(piece);
        }
        for (BasePiece piece : pawnMoveBoard.getCurrentChessPlayer().getOpponent().getActivePieces()) {
            builder.setPiece(piece);
        }
        builder.setPiece(this.promotedPawn.getPromotionPiece().movePiece(this));
        builder.setMoveMaker(pawnMoveBoard.getCurrentChessPlayer().getPieceColor());
        return builder.build();
    }

    @Override
    public boolean isAttack() {
        return this.decoratedMove.isAttack();
    }

    @Override
    public BasePiece getAttackedPiece() {
        return this.decoratedMove.getAttackedPiece();
    }

    public String toString() {
        return BoardUtils.getPositionAtCoordinate(this.destinationCoordinate) + "=Q";
    }

    @Override
    public String saveToNBT() {
        return "pawn_promotion/" + this.getColorForPiece(this.promotedPawn) + "/" + this.promotedPawn.getPiecePosition() + "/" + this.decoratedMove.getDestinationCoordinate();
    }
}

