/*
 * Decompiled with CFR 0.152.
 */
package andrews.table_top_craft.game_logic.chess.pieces;

import andrews.table_top_craft.game_logic.chess.PieceColor;
import andrews.table_top_craft.game_logic.chess.board.Board;
import andrews.table_top_craft.game_logic.chess.board.BoardUtils;
import andrews.table_top_craft.game_logic.chess.board.moves.BaseMove;
import andrews.table_top_craft.game_logic.chess.board.moves.PawnAttackMove;
import andrews.table_top_craft.game_logic.chess.board.moves.PawnEnPassantAttackMove;
import andrews.table_top_craft.game_logic.chess.board.moves.PawnJumpMove;
import andrews.table_top_craft.game_logic.chess.board.moves.PawnMove;
import andrews.table_top_craft.game_logic.chess.board.moves.PawnPromotion;
import andrews.table_top_craft.game_logic.chess.pieces.BasePiece;
import andrews.table_top_craft.game_logic.chess.pieces.QueenPiece;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;

public class PawnPiece
extends BasePiece {
    private static final int[] CANDIDATE_MOVE_COORDINATES = new int[]{7, 8, 9, 16};

    public PawnPiece(PieceColor pieceColor, int piecePosition) {
        super(BasePiece.PieceType.PAWN, piecePosition, pieceColor, true);
    }

    public PawnPiece(PieceColor pieceColor, int piecePosition, boolean isFirstMove) {
        super(BasePiece.PieceType.PAWN, piecePosition, pieceColor, isFirstMove);
    }

    @Override
    public Collection<BaseMove> calculateLegalMoves(Board board) {
        ArrayList<BaseMove> legalMoves = new ArrayList<BaseMove>();
        for (int currentCandidateOffset : CANDIDATE_MOVE_COORDINATES) {
            PawnPiece pieceOnCandidate;
            int candidateDestinationCoordinate = this.piecePosition + currentCandidateOffset * this.pieceColor.getDirection();
            if (!BoardUtils.isValidTileCoordinate(candidateDestinationCoordinate)) continue;
            if (currentCandidateOffset == 8 && !board.getTile(candidateDestinationCoordinate).isTileOccupied()) {
                if (this.pieceColor.isPawnPromotionSquare(candidateDestinationCoordinate)) {
                    legalMoves.add(new PawnPromotion(new PawnMove(board, this, candidateDestinationCoordinate)));
                    continue;
                }
                legalMoves.add(new PawnMove(board, this, candidateDestinationCoordinate));
                continue;
            }
            if (currentCandidateOffset == 16 && this.isFirstMove() && (BoardUtils.SEVENTH_RANK[this.piecePosition] && this.getPieceColor().isBlack() || BoardUtils.SECOND_RANK[this.piecePosition] && this.getPieceColor().isWhite())) {
                int behindCandidateDestinationCoordinate = this.piecePosition + this.pieceColor.getDirection() * 8;
                if (board.getTile(behindCandidateDestinationCoordinate).isTileOccupied() || board.getTile(candidateDestinationCoordinate).isTileOccupied()) continue;
                legalMoves.add(new PawnJumpMove(board, this, candidateDestinationCoordinate));
                continue;
            }
            if (!(currentCandidateOffset != 7 || BoardUtils.EIGHTH_COLUMN[this.piecePosition] && this.pieceColor.isWhite() || BoardUtils.FIRST_COLUMN[this.piecePosition] && this.pieceColor.isBlack())) {
                PawnPiece pieceOnCandidate2;
                if (board.getTile(candidateDestinationCoordinate).isTileOccupied()) {
                    BasePiece pieceOnCandidate3 = board.getTile(candidateDestinationCoordinate).getPiece();
                    if (this.pieceColor == pieceOnCandidate3.getPieceColor()) continue;
                    if (this.pieceColor.isPawnPromotionSquare(candidateDestinationCoordinate)) {
                        legalMoves.add(new PawnPromotion(new PawnAttackMove(board, this, candidateDestinationCoordinate, pieceOnCandidate3)));
                        continue;
                    }
                    legalMoves.add(new PawnAttackMove(board, this, candidateDestinationCoordinate, pieceOnCandidate3));
                    continue;
                }
                if (board.getEnPassantPawn() == null || board.getEnPassantPawn().getPiecePosition() != this.piecePosition + this.pieceColor.getOppositeDirection() || this.pieceColor == (pieceOnCandidate2 = board.getEnPassantPawn()).getPieceColor()) continue;
                legalMoves.add(new PawnEnPassantAttackMove(board, this, candidateDestinationCoordinate, pieceOnCandidate2));
                continue;
            }
            if (currentCandidateOffset != 9 || BoardUtils.FIRST_COLUMN[this.piecePosition] && this.pieceColor.isWhite() || BoardUtils.EIGHTH_COLUMN[this.piecePosition] && this.pieceColor.isBlack()) continue;
            if (board.getTile(candidateDestinationCoordinate).isTileOccupied()) {
                BasePiece pieceOnCandidate4 = board.getTile(candidateDestinationCoordinate).getPiece();
                if (this.pieceColor == pieceOnCandidate4.getPieceColor()) continue;
                if (this.pieceColor.isPawnPromotionSquare(candidateDestinationCoordinate)) {
                    legalMoves.add(new PawnPromotion(new PawnAttackMove(board, this, candidateDestinationCoordinate, pieceOnCandidate4)));
                    continue;
                }
                legalMoves.add(new PawnAttackMove(board, this, candidateDestinationCoordinate, pieceOnCandidate4));
                continue;
            }
            if (board.getEnPassantPawn() == null || board.getEnPassantPawn().getPiecePosition() != this.piecePosition - this.pieceColor.getOppositeDirection() || this.pieceColor == (pieceOnCandidate = board.getEnPassantPawn()).getPieceColor()) continue;
            legalMoves.add(new PawnEnPassantAttackMove(board, this, candidateDestinationCoordinate, pieceOnCandidate));
        }
        return ImmutableList.copyOf(legalMoves);
    }

    public String toString() {
        return BasePiece.PieceType.PAWN.toString();
    }

    @Override
    public int locationBonus() {
        return this.pieceColor.pawnBonus(this.piecePosition);
    }

    @Override
    public PawnPiece movePiece(BaseMove move) {
        return new PawnPiece(move.getMovedPiece().getPieceColor(), move.getDestinationCoordinate(), false);
    }

    public BasePiece getPromotionPiece() {
        return new QueenPiece(this.pieceColor, this.piecePosition, false);
    }
}

