/*
 * Decompiled with CFR 0.152.
 */
package andrews.table_top_craft.game_logic.chess.player;

import andrews.table_top_craft.game_logic.chess.PieceColor;
import andrews.table_top_craft.game_logic.chess.board.Board;
import andrews.table_top_craft.game_logic.chess.board.moves.BaseMove;
import andrews.table_top_craft.game_logic.chess.board.moves.CastleMove;
import andrews.table_top_craft.game_logic.chess.board.moves.KingSideCastleMove;
import andrews.table_top_craft.game_logic.chess.board.moves.QueenSideCastleMove;
import andrews.table_top_craft.game_logic.chess.board.tiles.BaseChessTile;
import andrews.table_top_craft.game_logic.chess.pieces.BasePiece;
import andrews.table_top_craft.game_logic.chess.pieces.RookPiece;
import andrews.table_top_craft.game_logic.chess.player.BaseChessPlayer;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;

public class BlackChessPlayer
extends BaseChessPlayer {
    public BlackChessPlayer(Board board, Collection<BaseMove> whiteStandardLegalMoves, Collection<BaseMove> blackStandardLegalMoves) {
        super(board, blackStandardLegalMoves, whiteStandardLegalMoves);
    }

    @Override
    public Collection<BasePiece> getActivePieces() {
        return this.board.getBlackPieces();
    }

    @Override
    public PieceColor getPieceColor() {
        return PieceColor.BLACK;
    }

    @Override
    public BaseChessPlayer getOpponent() {
        return this.board.getWhiteChessPlayer();
    }

    @Override
    public boolean isCastled() {
        return this.playerKing.isCastled();
    }

    @Override
    protected Collection<BaseMove> calculateKingCastles(Collection<BaseMove> playerLegals, Collection<BaseMove> opponentsLegals) {
        ArrayList<CastleMove> kingCastles = new ArrayList<CastleMove>();
        if (this.playerKing.isFirstMove() && !this.isInCheck()) {
            BaseChessTile rookTile;
            if (!this.board.getTile(5).isTileOccupied() && !this.board.getTile(6).isTileOccupied() && (rookTile = this.board.getTile(7)).isTileOccupied() && rookTile.getPiece().isFirstMove() && BaseChessPlayer.calculateAttacksOnTile(5, opponentsLegals).isEmpty() && BaseChessPlayer.calculateAttacksOnTile(6, opponentsLegals).isEmpty() && rookTile.getPiece().getPieceType().isRook() && this.playerKing.isKingSideCastleCapable()) {
                kingCastles.add(new KingSideCastleMove(this.board, this.playerKing, 6, (RookPiece)rookTile.getPiece(), rookTile.getTileCoordinate(), 5));
            }
            if (!this.board.getTile(1).isTileOccupied() && !this.board.getTile(2).isTileOccupied() && !this.board.getTile(3).isTileOccupied() && (rookTile = this.board.getTile(0)).isTileOccupied() && rookTile.getPiece().isFirstMove() && BaseChessPlayer.calculateAttacksOnTile(2, opponentsLegals).isEmpty() && BaseChessPlayer.calculateAttacksOnTile(3, opponentsLegals).isEmpty() && rookTile.getPiece().getPieceType().isRook() && this.playerKing.isQueenSideCastleCapable()) {
                kingCastles.add(new QueenSideCastleMove(this.board, this.playerKing, 2, (RookPiece)rookTile.getPiece(), rookTile.getTileCoordinate(), 3));
            }
        }
        return ImmutableList.copyOf(kingCastles);
    }

    public String toString() {
        return PieceColor.BLACK.toString();
    }
}

