/*
 * Decompiled with CFR 0.152.
 */
package andrews.table_top_craft.game_logic.chess.player.ai;

import andrews.table_top_craft.game_logic.chess.board.Board;
import andrews.table_top_craft.game_logic.chess.board.moves.BaseMove;
import andrews.table_top_craft.game_logic.chess.player.MoveTransition;
import andrews.table_top_craft.game_logic.chess.player.ai.BoardEvaluator;
import andrews.table_top_craft.game_logic.chess.player.ai.MoveStrategy;
import andrews.table_top_craft.game_logic.chess.player.ai.StandardBoardEvaluator;

public class MiniMax
implements MoveStrategy {
    private final BoardEvaluator boardEvaluator = new StandardBoardEvaluator();
    private final int searchDepth;

    public MiniMax(int searchDepth) {
        this.searchDepth = searchDepth;
    }

    public String toString() {
        return "MiniMax";
    }

    @Override
    public BaseMove execute(Board board) {
        BaseMove bestMove = null;
        int highestSeenValue = Integer.MIN_VALUE;
        int lowestSeenValue = Integer.MAX_VALUE;
        for (BaseMove move : board.getCurrentChessPlayer().getLegalMoves()) {
            int currentValue;
            MoveTransition moveTransition = board.getCurrentChessPlayer().makeMove(move);
            if (!moveTransition.getMoveStatus().isDone()) continue;
            int n = currentValue = board.getCurrentChessPlayer().getPieceColor().isWhite() ? this.min(moveTransition.getTransitionBoard(), this.searchDepth - 1) : this.max(moveTransition.getTransitionBoard(), this.searchDepth - 1);
            if (board.getCurrentChessPlayer().getPieceColor().isWhite() && currentValue >= highestSeenValue) {
                highestSeenValue = currentValue;
                bestMove = move;
                continue;
            }
            if (!board.getCurrentChessPlayer().getPieceColor().isBlack() || currentValue > lowestSeenValue) continue;
            lowestSeenValue = currentValue;
            bestMove = move;
        }
        return bestMove;
    }

    public int min(Board board, int depth) {
        if (depth == 0 || MiniMax.isEndGameScenario(board)) {
            return this.boardEvaluator.evaluate(board, this.searchDepth);
        }
        int lowestSeenValue = Integer.MAX_VALUE;
        for (BaseMove move : board.getCurrentChessPlayer().getLegalMoves()) {
            int currentValue;
            MoveTransition moveTransition = board.getCurrentChessPlayer().makeMove(move);
            if (!moveTransition.getMoveStatus().isDone() || (currentValue = this.max(moveTransition.getTransitionBoard(), depth - 1)) > lowestSeenValue) continue;
            lowestSeenValue = currentValue;
        }
        return lowestSeenValue;
    }

    public int max(Board board, int depth) {
        if (depth == 0 || MiniMax.isEndGameScenario(board)) {
            return this.boardEvaluator.evaluate(board, this.searchDepth);
        }
        int highestSeenValue = Integer.MIN_VALUE;
        for (BaseMove move : board.getCurrentChessPlayer().getLegalMoves()) {
            int currentValue;
            MoveTransition moveTransition = board.getCurrentChessPlayer().makeMove(move);
            if (!moveTransition.getMoveStatus().isDone() || (currentValue = this.min(moveTransition.getTransitionBoard(), depth - 1)) < highestSeenValue) continue;
            highestSeenValue = currentValue;
        }
        return highestSeenValue;
    }

    private static boolean isEndGameScenario(Board board) {
        return board.getCurrentChessPlayer().isInCheckMate() || board.getCurrentChessPlayer().isInStaleMate();
    }
}

