/*
 * Decompiled with CFR 0.152.
 */
package andrews.table_top_craft.network.server;

import andrews.table_top_craft.criteria.TTCCriteriaTriggers;
import andrews.table_top_craft.game_logic.chess.board.moves.BaseMove;
import andrews.table_top_craft.game_logic.chess.board.moves.MoveFactory;
import andrews.table_top_craft.game_logic.chess.board.tiles.BaseChessTile;
import andrews.table_top_craft.game_logic.chess.player.MoveTransition;
import andrews.table_top_craft.tile_entities.ChessTileEntity;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class MessageServerDoChessBoardInteraction {
    private final BlockPos pos;
    private final byte tileCoordinate;

    public MessageServerDoChessBoardInteraction(BlockPos pos, byte tileCoordinate) {
        this.pos = pos;
        this.tileCoordinate = tileCoordinate;
    }

    public void serialize(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.writeByte((int)this.tileCoordinate);
    }

    public static MessageServerDoChessBoardInteraction deserialize(FriendlyByteBuf buf) {
        BlockPos pos = buf.m_130135_();
        byte tileCoordinate = buf.readByte();
        return new MessageServerDoChessBoardInteraction(pos, tileCoordinate);
    }

    public static void handle(MessageServerDoChessBoardInteraction message, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        ServerPlayer player = context.getSender();
        ServerLevel level = player.m_9236_();
        BlockPos pos = message.pos;
        byte tileCoordinate = message.tileCoordinate;
        if (context.getDirection().getReceptionSide() == LogicalSide.SERVER) {
            context.enqueueWork(() -> MessageServerDoChessBoardInteraction.lambda$handle$0((Level)level, pos, tileCoordinate, player));
            context.setPacketHandled(true);
        }
    }

    private static /* synthetic */ void lambda$handle$0(Level level, BlockPos pos, byte tileCoordinate, ServerPlayer player) {
        BlockEntity blockEntity;
        if (level != null && (blockEntity = level.m_7702_(pos)) instanceof ChessTileEntity) {
            ChessTileEntity chessTileEntity = (ChessTileEntity)blockEntity;
            if (chessTileEntity.getBoard() == null) {
                return;
            }
            BaseChessTile chessTile = chessTileEntity.getBoard().getTile(tileCoordinate);
            if (chessTileEntity.getSourceTile() == null) {
                if (chessTile.isTileOccupied() && chessTile.getPiece().getPieceColor() == chessTileEntity.getBoard().getCurrentChessPlayer().getPieceColor()) {
                    chessTileEntity.setSourceTile(chessTile);
                    chessTileEntity.setHumanMovedPiece(chessTile.getPiece());
                    if (chessTileEntity.getHumanMovedPiece() == null) {
                        chessTileEntity.setSourceTile(null);
                    }
                    level.m_7260_(pos, level.m_8055_(pos), level.m_8055_(pos), 2);
                    chessTileEntity.m_6596_();
                }
            } else {
                chessTileEntity.setDestinationTile(chessTile);
                BaseMove move = MoveFactory.createMove(chessTileEntity.getBoard(), chessTileEntity.getSourceTile().getTileCoordinate(), chessTileEntity.getDestinationTile().getTileCoordinate());
                MoveTransition transition = chessTileEntity.getBoard().getCurrentChessPlayer().makeMove(move);
                if (transition.getMoveStatus().isDone()) {
                    chessTileEntity.setBoard(transition.getTransitionBoard());
                    chessTileEntity.getMoveLog().addMove(move);
                    if (!level.f_46443_) {
                        TTCCriteriaTriggers.MAKE_CHESS_MOVE.trigger(player);
                    }
                    if (move.isEnPassantMove() && !level.f_46443_) {
                        TTCCriteriaTriggers.MAKE_EN_PASSANT_MOVE.trigger(player);
                    }
                    if (chessTileEntity.getBoard().getCurrentChessPlayer().isInCheckMate() && !level.f_46443_) {
                        TTCCriteriaTriggers.MAKE_CHECK_MATE_MOVE.trigger(player);
                    }
                }
                chessTileEntity.setSourceTile(null);
                chessTileEntity.setDestinationTile(null);
                chessTileEntity.setHumanMovedPiece(null);
                level.m_7260_(pos, level.m_8055_(pos), level.m_8055_(pos), 2);
                chessTileEntity.m_6596_();
            }
        }
    }
}

