/*
 * Decompiled with CFR 0.152.
 */
package andrews.table_top_craft.network.server;

import andrews.table_top_craft.game_logic.chess.board.Board;
import andrews.table_top_craft.game_logic.chess.pgn.FenUtil;
import andrews.table_top_craft.tile_entities.ChessTileEntity;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import org.apache.commons.lang3.StringUtils;

public class MessageServerLoadFEN {
    private final BlockPos pos;
    private final String FEN;

    public MessageServerLoadFEN(BlockPos pos, String FEN) {
        this.pos = pos;
        this.FEN = FEN;
    }

    public void serialize(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.m_130070_(this.FEN);
    }

    public static MessageServerLoadFEN deserialize(FriendlyByteBuf buf) {
        BlockPos pos = buf.m_130135_();
        String FEN = buf.m_130136_(Short.MAX_VALUE);
        return new MessageServerLoadFEN(pos, FEN);
    }

    public static void handle(MessageServerLoadFEN message, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        ServerPlayer player = context.getSender();
        Level level = player.m_9236_();
        BlockPos chessPos = message.pos;
        String FEN = message.FEN;
        if (context.getDirection().getReceptionSide() == LogicalSide.SERVER) {
            context.enqueueWork(() -> MessageServerLoadFEN.lambda$handle$0(level, chessPos, FEN, (Player)player, message));
            context.setPacketHandled(true);
        }
    }

    private static boolean isFENValid(String FEN) {
        String[] FENInfo = FEN.split(" ");
        String[] boardTileInfo = FENInfo[0].split("/");
        int splitCounter = StringUtils.countMatches((CharSequence)FENInfo[0], (CharSequence)"/");
        int whiteKingCounter = StringUtils.countMatches((CharSequence)FENInfo[0], (CharSequence)"K");
        int blackKingCounter = StringUtils.countMatches((CharSequence)FENInfo[0], (CharSequence)"k");
        if (FENInfo.length != 6) {
            return false;
        }
        if (splitCounter != 7) {
            return false;
        }
        for (int i = 0; i < 8; ++i) {
            String rowInfo = boardTileInfo[i];
            int valueCounter = 0;
            for (int j = 0; j < rowInfo.length(); ++j) {
                if (rowInfo.charAt(j) == '1') {
                    ++valueCounter;
                    continue;
                }
                if (rowInfo.charAt(j) == '2') {
                    valueCounter += 2;
                    continue;
                }
                if (rowInfo.charAt(j) == '3') {
                    valueCounter += 3;
                    continue;
                }
                if (rowInfo.charAt(j) == '4') {
                    valueCounter += 4;
                    continue;
                }
                if (rowInfo.charAt(j) == '5') {
                    valueCounter += 5;
                    continue;
                }
                if (rowInfo.charAt(j) == '6') {
                    valueCounter += 6;
                    continue;
                }
                if (rowInfo.charAt(j) == '7') {
                    valueCounter += 7;
                    continue;
                }
                if (rowInfo.charAt(j) == '8') {
                    valueCounter += 8;
                    continue;
                }
                ++valueCounter;
            }
            if (valueCounter == 8) continue;
            return false;
        }
        if (whiteKingCounter != 1) {
            return false;
        }
        if (blackKingCounter != 1) {
            return false;
        }
        return FENInfo[1].equals("w") || FENInfo[1].equals("b");
    }

    private static /* synthetic */ void lambda$handle$0(Level level, BlockPos chessPos, String FEN, Player player, MessageServerLoadFEN message) {
        BlockEntity blockEntity;
        if (level != null && (blockEntity = level.m_7702_(chessPos)) instanceof ChessTileEntity) {
            ChessTileEntity chessTileEntity = (ChessTileEntity)blockEntity;
            Board board = Board.createStandardBoard();
            if (MessageServerLoadFEN.isFENValid(FEN)) {
                board = FenUtil.createGameFromFEN(FEN);
            } else {
                player.m_213846_((Component)Component.m_237115_((String)"message.table_top_craft.chess.invalidFEN").m_130940_(ChatFormatting.RED));
            }
            chessTileEntity.setBoard(board);
            chessTileEntity.getMoveLog().clear();
            level.m_7260_(message.pos, level.m_8055_(chessPos), level.m_8055_(chessPos), 2);
        }
    }
}

