/*
 * Decompiled with CFR 0.152.
 */
package andrews.table_top_craft.objects.blocks;

import andrews.table_top_craft.screens.chess.menus.ChessBoardSettingsScreen;
import andrews.table_top_craft.tile_entities.ChessTileEntity;
import andrews.table_top_craft.util.NetworkUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ChessBlock
extends HorizontalDirectionalBlock
implements EntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty SHOW_PLATE = BooleanProperty.m_61465_((String)"show_plate");
    protected static final VoxelShape CHESS_BLOCK_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);

    public ChessBlock() {
        super(ChessBlock.getProperties());
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)SHOW_PLATE, (Comparable)Boolean.valueOf(true)));
    }

    private static BlockBehaviour.Properties getProperties() {
        BlockBehaviour.Properties properties = BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_);
        properties.m_60978_(2.0f);
        properties.m_60955_();
        properties.m_60918_(SoundType.f_56736_);
        return properties;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_())).m_61124_((Property)SHOW_PLATE, (Comparable)Boolean.valueOf(true));
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        ChessTileEntity chessTileEntity;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof ChessTileEntity && (chessTileEntity = (ChessTileEntity)blockEntity).getUseCustomPlate()) {
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)SHOW_PLATE, (Comparable)Boolean.valueOf(false)));
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, SHOW_PLATE});
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return CHESS_BLOCK_AABB;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (player.m_6144_()) {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof ChessTileEntity) {
                ChessTileEntity chessTileEntity = (ChessTileEntity)blockEntity;
                if (level.f_46443_) {
                    ChessBoardSettingsScreen.open(chessTileEntity);
                }
            }
        } else {
            Direction face = hit.m_82434_();
            if (face.equals((Object)Direction.UP)) {
                Direction facing = (Direction)state.m_61143_((Property)FACING);
                int chessRank = this.getChessRank(hit.m_82450_(), facing) + 1;
                int chessColumn = this.getChessColumn(hit.m_82450_(), facing);
                byte tileCoordinate = (byte)Mth.m_14045_((int)((8 - chessRank) * 8 + chessColumn), (int)0, (int)63);
                if (level.f_46443_) {
                    NetworkUtil.doChessBoardInteraction(pos, tileCoordinate);
                }
            }
        }
        return InteractionResult.SUCCESS;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new ChessTileEntity(pos, state);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    private int getChessRank(Vec3 vec3d, Direction facing) {
        double value = facing == Direction.NORTH || facing == Direction.SOUTH ? vec3d.f_82481_ : vec3d.f_82479_;
        value -= Math.floor(value);
        value *= 100.0;
        return switch (facing) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.NORTH, Direction.WEST, Direction.DOWN, Direction.UP -> (int)(7.0 - Math.floor(value / 12.5));
            case Direction.SOUTH, Direction.EAST -> (int)Math.floor(value / 12.5);
        };
    }

    private int getChessColumn(Vec3 vec3d, Direction facing) {
        double value = facing == Direction.NORTH || facing == Direction.SOUTH ? vec3d.f_82479_ : vec3d.f_82481_;
        value -= Math.floor(value);
        value *= 100.0;
        return switch (facing) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.NORTH, Direction.DOWN, Direction.UP, Direction.EAST -> (int)Math.floor(value / 12.5);
            case Direction.WEST, Direction.SOUTH -> (int)(7.0 - Math.floor(value / 12.5));
        };
    }
}

