/*
 * Decompiled with CFR 0.152.
 */
package andrews.table_top_craft.screens.chess.buttons.colors;

import andrews.table_top_craft.screens.chess.sliders.ChessAlphaColorSlider;
import andrews.table_top_craft.screens.chess.sliders.ChessBlueColorSlider;
import andrews.table_top_craft.screens.chess.sliders.ChessGreenColorSlider;
import andrews.table_top_craft.screens.chess.sliders.ChessRedColorSlider;
import andrews.table_top_craft.tile_entities.ChessTileEntity;
import andrews.table_top_craft.util.NBTColorSaving;
import andrews.table_top_craft.util.NetworkUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class ChessConfirmColorButton
extends Button {
    private static final ResourceLocation TEXTURE = new ResourceLocation("table_top_craft:textures/gui/buttons/chess_menu_buttons.png");
    private final String buttonText = Component.m_237115_((String)"gui.table_top_craft.chess.confirm_color").getString();
    private final String buttonText2 = Component.m_237115_((String)"gui.table_top_craft.chess.confirm_colors").getString();
    private final Font fontRenderer;
    private static ChessTileEntity chessTileEntity;
    private static final int buttonWidth = 82;
    private static final int buttonHeight = 13;
    private int u = 0;
    private int v = 0;
    private static ChessRedColorSlider redSlider;
    private static ChessGreenColorSlider greenSlider;
    private static ChessBlueColorSlider blueSlider;
    private static ChessAlphaColorSlider alphaSlider;
    private static ChessRedColorSlider optionalRedSlider;
    private static ChessGreenColorSlider optionalGreenSlider;
    private static ChessBlueColorSlider optionalBlueSlider;
    private static ColorMenuType colorMenuType;

    public ChessConfirmColorButton(ColorMenuType colorMenu, ChessTileEntity tileEntity, ChessRedColorSlider red, ChessGreenColorSlider green, ChessBlueColorSlider blue, int xPos, int yPos) {
        super(xPos, yPos, 82, 13, (Component)Component.m_237113_((String)""), button -> ChessConfirmColorButton.handleButtonPress());
        this.fontRenderer = Minecraft.m_91087_().f_91062_;
        colorMenuType = colorMenu;
        chessTileEntity = tileEntity;
        redSlider = red;
        greenSlider = green;
        blueSlider = blue;
    }

    public ChessConfirmColorButton(ColorMenuType colorMenu, ChessTileEntity tileEntity, ChessRedColorSlider red, ChessGreenColorSlider green, ChessBlueColorSlider blue, ChessAlphaColorSlider alpha, int xPos, int yPos) {
        this(colorMenu, tileEntity, red, green, blue, xPos, yPos);
        alphaSlider = alpha;
    }

    public ChessConfirmColorButton(ColorMenuType colorMenu, ChessTileEntity tileEntity, ChessRedColorSlider red, ChessRedColorSlider optionalRed, ChessGreenColorSlider green, ChessGreenColorSlider optionalGreen, ChessBlueColorSlider blue, ChessBlueColorSlider optionalBlue, int xPos, int yPos) {
        this(colorMenu, tileEntity, red, green, blue, xPos, yPos);
        optionalRedSlider = optionalRed;
        optionalGreenSlider = optionalGreen;
        optionalBlueSlider = optionalBlue;
    }

    public void m_6303_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        this.f_93622_ = mouseX >= this.f_93620_ && mouseX < this.f_93620_ + this.f_93618_ && mouseY >= this.f_93621_ && mouseY < this.f_93621_ + this.f_93619_ || this.m_93696_();
        this.u = 0;
        if (this.f_93622_) {
            this.u = 82;
        }
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        poseStack.m_85836_();
        RenderSystem.m_69478_();
        this.m_93228_(poseStack, this.f_93620_, this.f_93621_, this.u, this.v, this.f_93618_, this.f_93619_);
        RenderSystem.m_69461_();
        poseStack.m_85849_();
        boolean useText2 = optionalRedSlider != null && optionalGreenSlider != null && optionalBlueSlider != null;
        this.fontRenderer.m_92883_(poseStack, useText2 ? this.buttonText2 : this.buttonText, (float)(this.f_93620_ + (this.f_93618_ / 2 - this.fontRenderer.m_92895_(useText2 ? this.buttonText2 : this.buttonText) / 2)), (float)(this.f_93621_ + 3), 0);
    }

    private static void handleButtonPress() {
        switch (colorMenuType) {
            default: {
                NetworkUtil.setColorMessage(0, chessTileEntity.m_58899_(), NBTColorSaving.saveColor(redSlider.getValueInt(), greenSlider.getValueInt(), blueSlider.getValueInt()));
                break;
            }
            case BOARD_PLATE: {
                if (optionalRedSlider == null || optionalGreenSlider == null || optionalBlueSlider == null) break;
                NetworkUtil.setColorsMessage(0, chessTileEntity.m_58899_(), NBTColorSaving.saveColor(redSlider.getValueInt(), greenSlider.getValueInt(), blueSlider.getValueInt()), NBTColorSaving.saveColor(optionalRedSlider.getValueInt(), optionalGreenSlider.getValueInt(), optionalBlueSlider.getValueInt()));
                break;
            }
            case PIECES: {
                if (optionalRedSlider == null || optionalGreenSlider == null || optionalBlueSlider == null) break;
                NetworkUtil.setColorsMessage(1, chessTileEntity.m_58899_(), NBTColorSaving.saveColor(redSlider.getValueInt(), greenSlider.getValueInt(), blueSlider.getValueInt()), NBTColorSaving.saveColor(optionalRedSlider.getValueInt(), optionalGreenSlider.getValueInt(), optionalBlueSlider.getValueInt()));
                break;
            }
            case LEGAL_MOVE: {
                if (alphaSlider == null) break;
                NetworkUtil.setColorMessage(1, chessTileEntity.m_58899_(), NBTColorSaving.saveColor(redSlider.getValueInt(), greenSlider.getValueInt(), blueSlider.getValueInt(), alphaSlider.getValueInt()));
                break;
            }
            case INVALID_MOVE: {
                if (alphaSlider == null) break;
                NetworkUtil.setColorMessage(2, chessTileEntity.m_58899_(), NBTColorSaving.saveColor(redSlider.getValueInt(), greenSlider.getValueInt(), blueSlider.getValueInt(), alphaSlider.getValueInt()));
                break;
            }
            case ATTACK_MOVE: {
                if (alphaSlider == null) break;
                NetworkUtil.setColorMessage(3, chessTileEntity.m_58899_(), NBTColorSaving.saveColor(redSlider.getValueInt(), greenSlider.getValueInt(), blueSlider.getValueInt(), alphaSlider.getValueInt()));
                break;
            }
            case PREVIOUS_MOVE: {
                if (alphaSlider == null) break;
                NetworkUtil.setColorMessage(4, chessTileEntity.m_58899_(), NBTColorSaving.saveColor(redSlider.getValueInt(), greenSlider.getValueInt(), blueSlider.getValueInt(), alphaSlider.getValueInt()));
                break;
            }
            case CASTLE_MOVE: {
                if (alphaSlider == null) break;
                NetworkUtil.setColorMessage(5, chessTileEntity.m_58899_(), NBTColorSaving.saveColor(redSlider.getValueInt(), greenSlider.getValueInt(), blueSlider.getValueInt(), alphaSlider.getValueInt()));
            }
        }
    }

    public static enum ColorMenuType {
        TILE_INFO,
        BOARD_PLATE,
        PIECES,
        LEGAL_MOVE,
        INVALID_MOVE,
        ATTACK_MOVE,
        PREVIOUS_MOVE,
        CASTLE_MOVE;

    }
}

