/*
 * Decompiled with CFR 0.152.
 */
package andrews.table_top_craft.screens.chess.buttons.pieces;

import andrews.table_top_craft.game_logic.chess.pieces.BasePiece;
import andrews.table_top_craft.registry.TTCBlocks;
import andrews.table_top_craft.tile_entities.ChessPieceFigureBlockEntity;
import andrews.table_top_craft.tile_entities.ChessTileEntity;
import andrews.table_top_craft.util.NetworkUtil;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class ChessBoardPieceModelSelectionButton
extends Button {
    private static final ResourceLocation TEXTURE = new ResourceLocation("table_top_craft:textures/gui/buttons/piece_model_selection_buttons.png");
    private final Component buttonText = Component.m_237115_((String)"tooltip.table_top_craft.chess.piece_type.standard");
    private final Component buttonTextClassic = Component.m_237115_((String)"tooltip.table_top_craft.chess.piece_type.classic");
    private final Component buttonTextPandorasCreatures = Component.m_237115_((String)"tooltip.table_top_craft.chess.piece_type.pandoras_creatures");
    private final Font fontRenderer;
    private static ChessTileEntity chessTileEntity;
    private static final int buttonWidth = 167;
    private static final int buttonHeight = 37;
    private int u = 0;
    private int v = 0;
    private final ChessPieceFigureBlockEntity chessPieceFigureBlockEntity;
    private final ItemStack chessPieceStack;
    private final BasePiece.PieceModelSet pieceModelSet;
    private final boolean isStandardSetUnlocked;
    private final boolean isClassicSetUnlocked;
    private final boolean isPandorasCreaturesSetUnlocked;

    public ChessBoardPieceModelSelectionButton(ChessTileEntity tileEntity, BasePiece.PieceModelSet pieceModelSet, boolean isStandardSetUnlocked, boolean isClassicSetUnlocked, boolean isPandorasCreaturesSetUnlocked, int xPos, int yPos) {
        super(xPos, yPos, 167, 37, (Component)Component.m_237113_((String)""), button -> ChessBoardPieceModelSelectionButton.handleButtonPress());
        this.fontRenderer = Minecraft.m_91087_().f_91062_;
        chessTileEntity = tileEntity;
        this.chessPieceFigureBlockEntity = new ChessPieceFigureBlockEntity(BlockPos.f_121853_, ((Block)TTCBlocks.CHESS_PIECE_FIGURE.get()).m_49966_());
        this.chessPieceStack = new ItemStack((ItemLike)((Block)TTCBlocks.CHESS_PIECE_FIGURE.get()).m_5456_());
        this.pieceModelSet = pieceModelSet;
        this.isStandardSetUnlocked = isStandardSetUnlocked;
        this.isClassicSetUnlocked = isClassicSetUnlocked;
        this.isPandorasCreaturesSetUnlocked = isPandorasCreaturesSetUnlocked;
    }

    public void m_6303_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        this.f_93622_ = mouseX >= this.f_93620_ && mouseX < this.f_93620_ + this.f_93618_ && mouseY >= this.f_93621_ && mouseY < this.f_93621_ + this.f_93619_ || this.m_93696_();
        this.v = 0;
        if (this.f_93622_ && !this.shouldButtonBeLocked()) {
            this.v += 37;
        }
        this.f_93623_ = !this.shouldButtonBeLocked();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        poseStack.m_85836_();
        RenderSystem.m_69478_();
        this.m_93228_(poseStack, this.f_93620_, this.f_93621_, this.u, this.v, this.f_93618_, this.f_93619_);
        switch (this.pieceModelSet) {
            case STANDARD: {
                if (chessTileEntity.getPieceSet() != 0) break;
                this.m_93228_(poseStack, this.f_93620_ - 1, this.f_93621_ - 1, 0, 74, this.f_93618_ + 2, this.f_93619_ + 2);
                break;
            }
            case CLASSIC: {
                if (chessTileEntity.getPieceSet() != 1) break;
                this.m_93228_(poseStack, this.f_93620_ - 1, this.f_93621_ - 1, 0, 74, this.f_93618_ + 2, this.f_93619_ + 2);
                break;
            }
            case PANDORAS_CREATURES: {
                if (chessTileEntity.getPieceSet() != 2) break;
                this.m_93228_(poseStack, this.f_93620_ - 1, this.f_93621_ - 1, 0, 74, this.f_93618_ + 2, this.f_93619_ + 2);
            }
        }
        RenderSystem.m_69461_();
        poseStack.m_85849_();
        switch (this.pieceModelSet) {
            case STANDARD: {
                this.chessPieceFigureBlockEntity.setPieceSet(1);
                break;
            }
            case CLASSIC: {
                this.chessPieceFigureBlockEntity.setPieceSet(2);
                break;
            }
            case PANDORAS_CREATURES: {
                this.chessPieceFigureBlockEntity.setPieceSet(3);
            }
        }
        this.chessPieceFigureBlockEntity.setRotateChessPieceFigure(true);
        int scale = 32;
        for (int i = 0; i < 6; ++i) {
            this.chessPieceFigureBlockEntity.setPieceType(i + 1);
            this.chessPieceFigureBlockEntity.m_187476_(this.chessPieceStack);
            this.renderChessPiece(poseStack, this.chessPieceStack, this.f_93620_ + 16 + 27 * i, this.f_93621_ + 16, scale);
        }
        switch (this.pieceModelSet) {
            case STANDARD: {
                Minecraft.m_91087_().f_91080_.renderTooltip(poseStack, Arrays.asList(this.buttonText.m_7532_()), this.f_93620_ - 8 + (this.f_93618_ / 2 - (this.fontRenderer.m_92852_((FormattedText)this.buttonText) + 8) / 2), this.f_93621_ + 1, this.fontRenderer);
                break;
            }
            case CLASSIC: {
                Minecraft.m_91087_().f_91080_.renderTooltip(poseStack, Arrays.asList(this.buttonTextClassic.m_7532_()), this.f_93620_ - 8 + (this.f_93618_ / 2 - (this.fontRenderer.m_92852_((FormattedText)this.buttonTextClassic) + 8) / 2), this.f_93621_ + 1, this.fontRenderer);
                break;
            }
            case PANDORAS_CREATURES: {
                Minecraft.m_91087_().f_91080_.renderTooltip(poseStack, Arrays.asList(this.buttonTextPandorasCreatures.m_7532_()), this.f_93620_ - 8 + (this.f_93618_ / 2 - (this.fontRenderer.m_92852_((FormattedText)this.buttonTextPandorasCreatures) + 8) / 2), this.f_93621_ + 1, this.fontRenderer);
            }
        }
        if (this.shouldButtonBeLocked()) {
            RenderSystem.m_69478_();
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)0.85f);
            RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
            this.m_93228_(poseStack, this.f_93620_ + 1, this.f_93621_ + 11, 0, 113, 165, 15);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_69461_();
            poseStack.m_85836_();
            poseStack.m_85837_(0.0, 0.0, 200.0);
            this.fontRenderer.m_92889_(poseStack, (Component)Component.m_237113_((String)"Locked"), (float)(this.f_93620_ + this.f_93618_ / 4 - this.fontRenderer.m_92895_("Locked") / 2), (float)(this.f_93621_ + 15), 0xFFFFFF);
            this.fontRenderer.m_92889_(poseStack, (Component)Component.m_237113_((String)"Locked"), (float)(this.f_93620_ + this.f_93618_ / 4 * 3 - this.fontRenderer.m_92895_("Locked") / 2), (float)(this.f_93621_ + 15), 0xFFFFFF);
            poseStack.m_85849_();
        }
    }

    private void renderChessPiece(PoseStack poseStack, ItemStack itemStack, int pX, int pY, int size) {
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        BakedModel itemBakedModel = itemRenderer.m_174264_(itemStack, null, null, 0);
        Minecraft.m_91087_().m_91097_().m_118506_(TextureAtlas.f_118259_).m_117960_(false, false);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TextureAtlas.f_118259_);
        RenderSystem.m_69478_();
        RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.m_85836_();
        poseStack.m_85837_((double)pX, (double)pY, 100.0);
        poseStack.m_85841_(1.0f, -1.0f, 1.0f);
        poseStack.m_85841_((float)size, (float)size, (float)size);
        RenderSystem.m_157182_();
        MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
        Lighting.m_84930_();
        itemRenderer.m_115143_(itemStack, ItemTransforms.TransformType.GUI, false, poseStack, (MultiBufferSource)bufferSource, 0xF000F0, OverlayTexture.f_118083_, itemBakedModel);
        bufferSource.m_109911_();
        poseStack.m_85849_();
        RenderSystem.m_157182_();
    }

    public void m_5716_(double pMouseX, double pMouseY) {
        switch (this.pieceModelSet) {
            case STANDARD: {
                NetworkUtil.setChessPieceSet(chessTileEntity.m_58899_(), 0);
                break;
            }
            case CLASSIC: {
                NetworkUtil.setChessPieceSet(chessTileEntity.m_58899_(), 1);
                break;
            }
            case PANDORAS_CREATURES: {
                NetworkUtil.setChessPieceSet(chessTileEntity.m_58899_(), 2);
            }
        }
    }

    private static void handleButtonPress() {
    }

    private boolean shouldButtonBeLocked() {
        if (!Minecraft.m_91087_().f_91074_.m_7500_()) {
            return switch (this.pieceModelSet) {
                default -> throw new IncompatibleClassChangeError();
                case BasePiece.PieceModelSet.STANDARD -> {
                    if (!this.isStandardSetUnlocked) {
                        yield true;
                    }
                    yield false;
                }
                case BasePiece.PieceModelSet.CLASSIC -> {
                    if (!this.isClassicSetUnlocked) {
                        yield true;
                    }
                    yield false;
                }
                case BasePiece.PieceModelSet.PANDORAS_CREATURES -> !this.isPandorasCreaturesSetUnlocked;
            };
        }
        return false;
    }
}

