/*
 * Decompiled with CFR 0.152.
 */
package andrews.table_top_craft.screens.chess.menus;

import andrews.table_top_craft.game_logic.chess.player.ai.StandardBoardEvaluator;
import andrews.table_top_craft.screens.chess.buttons.ChessCancelButton;
import andrews.table_top_craft.tile_entities.ChessTileEntity;
import com.google.common.primitives.Ints;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class ChessBoardEvaluatorScreen
extends Screen {
    private static final ResourceLocation MENU_TEXTURE = new ResourceLocation("table_top_craft", "textures/gui/menus/chess_menu.png");
    private final String chessBoardEvaluatorText = Component.m_237115_((String)"gui.table_top_craft.chess.board_evaluator").getString();
    private final String whitePlayerText = Component.m_237115_((String)"gui.table_top_craft.chess.evaluation.white_player").getString();
    private final String blackPlayerText = Component.m_237115_((String)"gui.table_top_craft.chess.evaluation.black_player").getString();
    private final String currentScoreText = Component.m_237115_((String)"gui.table_top_craft.chess.evaluation.current_score").getString();
    private final String boardEvaluationText;
    private final ChessTileEntity chessTileEntity;
    private final LocalPlayer clientPlayer;
    private final int xSize = 177;
    private final int ySize = 198;

    public ChessBoardEvaluatorScreen(ChessTileEntity chessTileEntity) {
        super((Component)Component.m_237113_((String)""));
        this.chessTileEntity = chessTileEntity;
        this.boardEvaluationText = StandardBoardEvaluator.get().evaluationDetails(chessTileEntity.getBoard(), 0);
        this.clientPlayer = Minecraft.m_91087_().f_91074_;
    }

    public boolean m_7043_() {
        return false;
    }

    protected void m_7856_() {
        super.m_7856_();
        int x = (this.f_96543_ - this.xSize) / 2;
        int y = (this.f_96544_ - this.ySize) / 2;
        this.m_142416_((GuiEventListener)new ChessCancelButton(this.chessTileEntity, ChessCancelButton.ChessCancelMenuTarget.CHESS_BOARD_SETTINGS, ChessCancelButton.ChessCancelButtonText.BACK, x + 88 - 41, y + 180));
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        int x = (this.f_96543_ - this.xSize) / 2;
        int y = (this.f_96544_ - this.ySize) / 2;
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)MENU_TEXTURE);
        this.m_93228_(poseStack, x, y, 0, 0, this.xSize, this.ySize);
        this.m_93228_(poseStack, x + 5, y + 152, 0, 224, 167, 12);
        int offset = StandardBoardEvaluator.get().evaluate(this.chessTileEntity.getBoard(), 1) / 23;
        offset = Ints.constrainToRange((int)offset, (int)-80, (int)84);
        poseStack.m_85836_();
        poseStack.m_85837_((double)offset, 0.0, 0.0);
        if (this.clientPlayer.f_19797_ % 16 <= 8) {
            this.m_93228_(poseStack, x + 83, y + 162, 3, 198, 7, 5);
        }
        poseStack.m_85849_();
        offset = Ints.constrainToRange((int)offset, (int)(-82 + this.f_96547_.m_92895_(this.currentScoreText) / 2), (int)(88 - this.f_96547_.m_92895_(this.currentScoreText) / 2));
        poseStack.m_85836_();
        poseStack.m_85837_((double)offset, 0.0, 0.0);
        this.f_96547_.m_92883_(poseStack, this.currentScoreText, (float)(x + 86 - this.f_96547_.m_92895_(this.currentScoreText) / 2), (float)(y + 168), 0);
        poseStack.m_85849_();
        this.f_96547_.m_92883_(poseStack, this.chessBoardEvaluatorText, (float)(this.f_96543_ / 2 - this.f_96547_.m_92895_(this.chessBoardEvaluatorText) / 2), (float)(y + 6), 0x404040);
        this.f_96547_.m_92883_(poseStack, this.blackPlayerText, (float)(x + 7), (float)(y + 154), 0xFFFFFF);
        this.f_96547_.m_92883_(poseStack, this.whitePlayerText, (float)(x + 177 - (this.f_96547_.m_92895_(this.whitePlayerText) + 6)), (float)(y + 154), 0);
        this.renderEvaluationText(poseStack, x, y);
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        super.m_7933_(keyCode, scanCode, modifiers);
        InputConstants.Key mouseKey = InputConstants.m_84827_((int)keyCode, (int)scanCode);
        if (this.f_96541_.f_91066_.f_92092_.isActiveAndMatches(mouseKey)) {
            this.m_7379_();
        }
        return true;
    }

    private void renderEvaluationText(PoseStack poseStack, int x, int y) {
        String[] evaluationLines;
        for (String evaluationLine : evaluationLines = this.boardEvaluationText.split("\n")) {
            this.f_96547_.m_92883_(poseStack, evaluationLine, (float)(x + 5), (float)(y + 17), 0);
            y += 9;
        }
    }
}

