/*
 * Decompiled with CFR 0.152.
 */
package andrews.table_top_craft.screens.chess.menus.color_selection;

import andrews.table_top_craft.screens.chess.buttons.ChessCancelButton;
import andrews.table_top_craft.screens.chess.buttons.colors.ChessConfirmColorButton;
import andrews.table_top_craft.screens.chess.buttons.colors.ChessRandomColorButton;
import andrews.table_top_craft.screens.chess.buttons.colors.ChessResetColorButton;
import andrews.table_top_craft.screens.chess.sliders.ChessBlueColorSlider;
import andrews.table_top_craft.screens.chess.sliders.ChessGreenColorSlider;
import andrews.table_top_craft.screens.chess.sliders.ChessRedColorSlider;
import andrews.table_top_craft.screens.piece_figure.util.ColorPickerToggleButton;
import andrews.table_top_craft.screens.piece_figure.util.IColorPicker;
import andrews.table_top_craft.screens.piece_figure.util.IColorPickerExtended;
import andrews.table_top_craft.screens.piece_figure.util.SaturationSlider;
import andrews.table_top_craft.screens.piece_figure.util.TTCColorPicker;
import andrews.table_top_craft.tile_entities.ChessTileEntity;
import andrews.table_top_craft.util.Color;
import andrews.table_top_craft.util.NBTColorSaving;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.gui.widget.ForgeSlider;

public class ChessBoardTilesColorScreen
extends Screen
implements IColorPicker,
IColorPickerExtended {
    private static final ResourceLocation MENU_TEXTURE = new ResourceLocation("table_top_craft", "textures/gui/menus/chess_menu.png");
    private static final ResourceLocation PREVIEW_TEXTURE = new ResourceLocation("table_top_craft", "textures/gui/menus/preview_color.png");
    private static final ResourceLocation PREVIEW_FRAME_TEXTURE = new ResourceLocation("table_top_craft", "textures/gui/menus/medium_chess_menu.png");
    private static final ResourceLocation COLOR_PICKER_FRAME_TEXTURE = new ResourceLocation("table_top_craft", "textures/gui/color_picker/color_picker_frame.png");
    private final String colorSelectionText = Component.m_237115_((String)"gui.table_top_craft.chess.color.tiles").getString();
    private final String previewColorText = Component.m_237115_((String)"gui.table_top_craft.chess.color.colors_preview").getString();
    private final String whiteTileSettingsText = Component.m_237115_((String)"gui.table_top_craft.chess.color.white_tiles_settings").getString();
    private final String blackTileSettingsText = Component.m_237115_((String)"gui.table_top_craft.chess.color.black_tiles_settings").getString();
    private final ChessTileEntity chessTileEntity;
    private final int xSize = 177;
    private final int ySize = 198;
    private ChessRedColorSlider whiteRedColorSlider;
    private ChessGreenColorSlider whiteGreenColorSlider;
    private ChessBlueColorSlider whiteBlueColorSlider;
    private ChessRedColorSlider blackRedColorSlider;
    private ChessGreenColorSlider blackGreenColorSlider;
    private ChessBlueColorSlider blackBlueColorSlider;
    private TTCColorPicker colorPicker;
    private SaturationSlider saturationSlider;
    private final boolean isColorPickerActive;
    private final boolean isOptionalColorPickerActive;

    public ChessBoardTilesColorScreen(ChessTileEntity chessTileEntity, boolean isColorPickerActive, boolean isOptionalColorPickerActive) {
        super((Component)Component.m_237113_((String)""));
        this.chessTileEntity = chessTileEntity;
        this.isColorPickerActive = isColorPickerActive;
        this.isOptionalColorPickerActive = isOptionalColorPickerActive;
    }

    public boolean m_7043_() {
        return false;
    }

    protected void m_7856_() {
        super.m_7856_();
        int x = (this.f_96543_ - (this.xSize - (this.isColorPickerActive || this.isOptionalColorPickerActive ? 136 : 0))) / 2;
        int y = (this.f_96544_ - this.ySize) / 2;
        this.m_142416_((GuiEventListener)new ColorPickerToggleButton(this.chessTileEntity, this, false, x + 68, y + 54));
        this.m_142416_((GuiEventListener)new ColorPickerToggleButton(this.chessTileEntity, this, true, x + 153, y + 54));
        this.whiteRedColorSlider = new ChessRedColorSlider(x + 5, y + 92, 167, 12, NBTColorSaving.getRed(this.chessTileEntity.getWhiteTilesColor()), this);
        this.m_142416_((GuiEventListener)this.whiteRedColorSlider);
        this.whiteGreenColorSlider = new ChessGreenColorSlider(x + 5, y + 105, 167, 12, NBTColorSaving.getGreen(this.chessTileEntity.getWhiteTilesColor()), this);
        this.m_142416_((GuiEventListener)this.whiteGreenColorSlider);
        this.whiteBlueColorSlider = new ChessBlueColorSlider(x + 5, y + 118, 167, 12, NBTColorSaving.getBlue(this.chessTileEntity.getWhiteTilesColor()), this);
        this.m_142416_((GuiEventListener)this.whiteBlueColorSlider);
        this.blackRedColorSlider = new ChessRedColorSlider(x + 5, y + 141, 167, 12, NBTColorSaving.getRed(this.chessTileEntity.getBlackTilesColor()), this);
        this.m_142416_((GuiEventListener)this.blackRedColorSlider);
        this.blackGreenColorSlider = new ChessGreenColorSlider(x + 5, y + 154, 167, 12, NBTColorSaving.getGreen(this.chessTileEntity.getBlackTilesColor()), this);
        this.m_142416_((GuiEventListener)this.blackGreenColorSlider);
        this.blackBlueColorSlider = new ChessBlueColorSlider(x + 5, y + 167, 167, 12, NBTColorSaving.getBlue(this.chessTileEntity.getBlackTilesColor()), this);
        this.m_142416_((GuiEventListener)this.blackBlueColorSlider);
        this.m_142416_((GuiEventListener)new ChessRandomColorButton(this, x + 5, y + 68));
        this.m_142416_((GuiEventListener)new ChessResetColorButton(ChessResetColorButton.DefaultColorType.BOARD_TILES, this, x + 90, y + 68));
        this.m_142416_((GuiEventListener)new ChessCancelButton(this.chessTileEntity, ChessCancelButton.ChessCancelMenuTarget.CHESS_BOARD_COLORS, ChessCancelButton.ChessCancelButtonText.CANCEL, x + 5, y + 180));
        this.m_142416_((GuiEventListener)new ChessConfirmColorButton(ChessConfirmColorButton.ColorMenuType.BOARD_PLATE, this.chessTileEntity, this.whiteRedColorSlider, this.blackRedColorSlider, this.whiteGreenColorSlider, this.blackGreenColorSlider, this.whiteBlueColorSlider, this.blackBlueColorSlider, x + 90, y + 180));
        if (this.isColorPickerActive) {
            Color color = new Color(this.whiteRedColorSlider.getValueInt(), this.whiteGreenColorSlider.getValueInt(), this.whiteBlueColorSlider.getValueInt());
            this.colorPicker = new TTCColorPicker(x - 131, y + 28, this, color.getHue() / 360.0f, 1.0f - color.getValue());
            this.m_142416_((GuiEventListener)this.colorPicker);
            float saturation = color.getSaturation() * 100.0f;
            this.saturationSlider = new SaturationSlider(x - 132, y + 158, 130, 12, Math.round(saturation), this);
            this.m_142416_((GuiEventListener)this.saturationSlider);
        } else if (this.isOptionalColorPickerActive) {
            Color color = new Color(this.blackRedColorSlider.getValueInt(), this.blackGreenColorSlider.getValueInt(), this.blackBlueColorSlider.getValueInt());
            this.colorPicker = new TTCColorPicker(x - 131, y + 28, this, color.getHue() / 360.0f, 1.0f - color.getValue());
            this.m_142416_((GuiEventListener)this.colorPicker);
            float saturation = color.getSaturation() * 100.0f;
            this.saturationSlider = new SaturationSlider(x - 132, y + 158, 130, 12, Math.round(saturation), this);
            this.m_142416_((GuiEventListener)this.saturationSlider);
        }
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        int x = (this.f_96543_ - (this.xSize - (this.isColorPickerActive || this.isOptionalColorPickerActive ? 136 : 0))) / 2;
        int y = (this.f_96544_ - this.ySize) / 2;
        if (this.isColorPickerActive || this.isOptionalColorPickerActive) {
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157456_((int)0, (ResourceLocation)COLOR_PICKER_FRAME_TEXTURE);
            this.m_93228_(poseStack, x - 136, y + 23, 0, 0, 136, 151);
        }
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)MENU_TEXTURE);
        this.m_93228_(poseStack, x, y, 0, 0, this.xSize, this.ySize);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)PREVIEW_FRAME_TEXTURE);
        this.m_93228_(poseStack, x + 25, y + 25, 0, 131, 42, 42);
        this.m_93228_(poseStack, x + 110, y + 25, 0, 131, 42, 42);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)PREVIEW_TEXTURE);
        poseStack.m_85836_();
        RenderSystem.m_157429_((float)(0.003921569f * (float)this.whiteRedColorSlider.getValueInt()), (float)(0.003921569f * (float)this.whiteGreenColorSlider.getValueInt()), (float)(0.003921569f * (float)this.whiteBlueColorSlider.getValueInt()), (float)1.0f);
        poseStack.m_85837_((double)(x + 26), (double)(y + 26), 0.0);
        poseStack.m_85841_(2.5f, 2.5f, 2.5f);
        this.m_93228_(poseStack, 0, 0, 0, 0, 16, 16);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.m_85849_();
        poseStack.m_85836_();
        RenderSystem.m_157429_((float)(0.003921569f * (float)this.blackRedColorSlider.getValueInt()), (float)(0.003921569f * (float)this.blackGreenColorSlider.getValueInt()), (float)(0.003921569f * (float)this.blackBlueColorSlider.getValueInt()), (float)1.0f);
        poseStack.m_85837_((double)(x + 111), (double)(y + 26), 0.0);
        poseStack.m_85841_(2.5f, 2.5f, 2.5f);
        this.m_93228_(poseStack, 0, 0, 0, 0, 16, 16);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.m_85849_();
        this.f_96547_.m_92883_(poseStack, this.colorSelectionText, (float)(this.f_96543_ / 2 - this.f_96547_.m_92895_(this.colorSelectionText) / 2 + (this.isColorPickerActive || this.isOptionalColorPickerActive ? 68 : 0)), (float)(y + 6), 0x404040);
        this.f_96547_.m_92883_(poseStack, this.previewColorText, (float)(x + 88 - this.f_96547_.m_92895_(this.previewColorText) / 2), (float)(y + 16), 0);
        this.f_96547_.m_92883_(poseStack, this.whiteTileSettingsText, (float)(x + 5), (float)(y + 83), 0);
        this.f_96547_.m_92883_(poseStack, this.blackTileSettingsText, (float)(x + 5), (float)(y + 132), 0);
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        super.m_7933_(keyCode, scanCode, modifiers);
        InputConstants.Key mouseKey = InputConstants.m_84827_((int)keyCode, (int)scanCode);
        if (this.f_96541_.f_91066_.f_92092_.isActiveAndMatches(mouseKey)) {
            this.m_7379_();
        }
        return true;
    }

    @Override
    public TTCColorPicker getColorPicker() {
        return this.colorPicker;
    }

    @Override
    public ForgeSlider getRedSlider() {
        return this.whiteRedColorSlider;
    }

    @Override
    public ForgeSlider getGreenSlider() {
        return this.whiteGreenColorSlider;
    }

    @Override
    public ForgeSlider getBlueSlider() {
        return this.whiteBlueColorSlider;
    }

    @Override
    public ForgeSlider getSaturationSlider() {
        return this.saturationSlider;
    }

    @Override
    public boolean isColorPickerActive() {
        return this.isColorPickerActive;
    }

    @Override
    public ForgeSlider getOptionalRedSlider() {
        return this.blackRedColorSlider;
    }

    @Override
    public ForgeSlider getOptionalGreenSlider() {
        return this.blackGreenColorSlider;
    }

    @Override
    public ForgeSlider getOptionalBlueSlider() {
        return this.blackBlueColorSlider;
    }

    @Override
    public boolean isOptionalColorPickerActive() {
        return this.isOptionalColorPickerActive;
    }
}

