/*
 * Decompiled with CFR 0.152.
 */
package andrews.table_top_craft.screens.piece_figure.menus;

import andrews.table_top_craft.registry.TTCBlocks;
import andrews.table_top_craft.screens.chess.buttons.pieces.creative_mode.ChessBoardPieceNextSetButton;
import andrews.table_top_craft.screens.chess.buttons.pieces.creative_mode.ChessBoardPieceNextTypeButton;
import andrews.table_top_craft.screens.chess.buttons.pieces.creative_mode.ChessBoardPiecePreviousSetButton;
import andrews.table_top_craft.screens.chess.buttons.pieces.creative_mode.ChessBoardPiecePreviousTypeButton;
import andrews.table_top_craft.screens.chess.sliders.ChessBlueColorSlider;
import andrews.table_top_craft.screens.chess.sliders.ChessGreenColorSlider;
import andrews.table_top_craft.screens.chess.sliders.ChessRedColorSlider;
import andrews.table_top_craft.screens.piece_figure.buttons.ChessPieceFigureConfirmColorButton;
import andrews.table_top_craft.screens.piece_figure.buttons.ChessPieceFigureConfirmScaleButton;
import andrews.table_top_craft.screens.piece_figure.buttons.ChessPieceFigureResetColorButton;
import andrews.table_top_craft.screens.piece_figure.buttons.ChessPieceFigureRotateButton;
import andrews.table_top_craft.screens.piece_figure.sliders.ChessPieceFigureScaleSlider;
import andrews.table_top_craft.screens.piece_figure.util.ColorPickerToggleButton;
import andrews.table_top_craft.screens.piece_figure.util.IColorPicker;
import andrews.table_top_craft.screens.piece_figure.util.SaturationSlider;
import andrews.table_top_craft.screens.piece_figure.util.TTCColorPicker;
import andrews.table_top_craft.tile_entities.ChessPieceFigureBlockEntity;
import andrews.table_top_craft.util.Color;
import andrews.table_top_craft.util.NBTColorSaving;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.gui.widget.ForgeSlider;

public class ChessPieceFigureSettingsScreen
extends Screen
implements IColorPicker {
    private static final ResourceLocation MENU_TEXTURE = new ResourceLocation("table_top_craft", "textures/gui/menus/chess_piece_figure_menu.png");
    private static final ResourceLocation COLOR_PICKER_FRAME_TEXTURE = new ResourceLocation("table_top_craft", "textures/gui/color_picker/color_picker_frame.png");
    private final String chessPieceFigureSettingsText = Component.m_237115_((String)"gui.table_top_craft.piece_figure.piece_settings").getString();
    private final String togglePieceRotationText = Component.m_237115_((String)"gui.table_top_craft.piece_figure.toggle_rotation").getString();
    private final ChessPieceFigureBlockEntity chessPieceFigureBlockEntity;
    private final int xSize = 177;
    private final int ySize = 158;
    private ChessRedColorSlider redColorSlider;
    private ChessGreenColorSlider greenColorSlider;
    private ChessBlueColorSlider blueColorSlider;
    private ChessPieceFigureScaleSlider scaleSlider;
    public TTCColorPicker colorPicker;
    private SaturationSlider saturationSlider;
    private final ChessPieceFigureBlockEntity previewBlockEntity;
    private final ItemStack chessPieceFigureStack;
    public boolean isColorPickerActive;

    public ChessPieceFigureSettingsScreen(ChessPieceFigureBlockEntity chessPieceFigureBlockEntity, boolean isColorPickerActive) {
        super((Component)Component.m_237113_((String)""));
        this.chessPieceFigureBlockEntity = chessPieceFigureBlockEntity;
        this.isColorPickerActive = isColorPickerActive;
        this.previewBlockEntity = new ChessPieceFigureBlockEntity(BlockPos.f_121853_, ((Block)TTCBlocks.CHESS_PIECE_FIGURE.get()).m_49966_());
        this.chessPieceFigureStack = new ItemStack((ItemLike)((Block)TTCBlocks.CHESS_PIECE_FIGURE.get()).m_5456_());
    }

    public boolean m_7043_() {
        return false;
    }

    protected void m_7856_() {
        super.m_7856_();
        int x = (this.f_96543_ - (this.xSize - (this.isColorPickerActive ? 136 : 0))) / 2;
        int y = (this.f_96544_ - this.ySize) / 2;
        this.m_142416_((GuiEventListener)new ChessPieceFigureRotateButton(this.chessPieceFigureBlockEntity, x + 5, y + 60));
        this.m_142416_((GuiEventListener)new ColorPickerToggleButton(this.chessPieceFigureBlockEntity, this, false, x + 159, y + 60));
        this.redColorSlider = new ChessRedColorSlider(x + 5, y + 74, 167, 12, NBTColorSaving.getRed(this.chessPieceFigureBlockEntity.getPieceColor()), this);
        this.m_142416_((GuiEventListener)this.redColorSlider);
        this.greenColorSlider = new ChessGreenColorSlider(x + 5, y + 87, 167, 12, NBTColorSaving.getGreen(this.chessPieceFigureBlockEntity.getPieceColor()), this);
        this.m_142416_((GuiEventListener)this.greenColorSlider);
        this.blueColorSlider = new ChessBlueColorSlider(x + 5, y + 100, 167, 12, NBTColorSaving.getBlue(this.chessPieceFigureBlockEntity.getPieceColor()), this);
        this.m_142416_((GuiEventListener)this.blueColorSlider);
        this.m_142416_((GuiEventListener)new ChessPieceFigureResetColorButton(this, x + 5, y + 113));
        this.m_142416_((GuiEventListener)new ChessPieceFigureConfirmColorButton(this.chessPieceFigureBlockEntity, this.redColorSlider, this.greenColorSlider, this.blueColorSlider, x + 90, y + 113));
        this.scaleSlider = new ChessPieceFigureScaleSlider(x + 5, y + 127, 167, 12, this.chessPieceFigureBlockEntity.getPieceScale());
        this.m_142416_((GuiEventListener)this.scaleSlider);
        this.m_142416_((GuiEventListener)new ChessPieceFigureConfirmScaleButton(this.chessPieceFigureBlockEntity, this.scaleSlider, x + 5, y + 140));
        if (this.isColorPickerActive) {
            Color color = new Color(this.redColorSlider.getValueInt(), this.greenColorSlider.getValueInt(), this.blueColorSlider.getValueInt());
            this.colorPicker = new TTCColorPicker(x - 131, y + 8, this, color.getHue() / 360.0f, 1.0f - color.getValue());
            this.m_142416_((GuiEventListener)this.colorPicker);
            float saturation = color.getSaturation() * 100.0f;
            this.saturationSlider = new SaturationSlider(x - 132, y + 138, 130, 12, Math.round(saturation), this);
            this.m_142416_((GuiEventListener)this.saturationSlider);
        }
        this.m_142416_((GuiEventListener)new ChessBoardPiecePreviousSetButton(this.chessPieceFigureBlockEntity, x + 5, y + 22));
        this.m_142416_((GuiEventListener)new ChessBoardPiecePreviousTypeButton(this.chessPieceFigureBlockEntity, x + 5, y + 38));
        this.m_142416_((GuiEventListener)new ChessBoardPieceNextSetButton(this.chessPieceFigureBlockEntity, x + 146, y + 22));
        this.m_142416_((GuiEventListener)new ChessBoardPieceNextTypeButton(this.chessPieceFigureBlockEntity, x + 146, y + 38));
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        int x = (this.f_96543_ - (this.xSize - (this.isColorPickerActive ? 136 : 0))) / 2;
        int y = (this.f_96544_ - this.ySize) / 2;
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)MENU_TEXTURE);
        this.m_93228_(poseStack, x, y, 0, 0, this.xSize, this.ySize);
        if (this.isColorPickerActive) {
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157456_((int)0, (ResourceLocation)COLOR_PICKER_FRAME_TEXTURE);
            this.m_93228_(poseStack, x - 136, y + 3, 0, 0, 136, 151);
        }
        this.f_96547_.m_92883_(poseStack, this.chessPieceFigureSettingsText, (float)(this.f_96543_ / 2 - this.f_96547_.m_92895_(this.chessPieceFigureSettingsText) / 2 + (this.isColorPickerActive ? 68 : 0)), (float)(y + 6), 0x404040);
        this.f_96547_.m_92883_(poseStack, this.togglePieceRotationText, (float)(x + 20), (float)(y + 63), 0);
        this.previewBlockEntity.setPieceSet(this.chessPieceFigureBlockEntity.getPieceSet());
        this.previewBlockEntity.setPieceType(this.chessPieceFigureBlockEntity.getPieceType());
        this.previewBlockEntity.setPieceColor(NBTColorSaving.saveColor(this.redColorSlider.getValueInt(), this.greenColorSlider.getValueInt(), this.blueColorSlider.getValueInt()));
        this.previewBlockEntity.setRotateChessPieceFigure(this.chessPieceFigureBlockEntity.getRotateChessPieceFigure());
        this.previewBlockEntity.m_187476_(this.chessPieceFigureStack);
        this.renderChessPiece(poseStack, this.chessPieceFigureStack, x + 88, y + 33, 52);
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
    }

    private void renderChessPiece(PoseStack poseStack, ItemStack itemStack, int pX, int pY, int size) {
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        BakedModel itemBakedModel = itemRenderer.m_174264_(itemStack, null, null, 0);
        Minecraft.m_91087_().m_91097_().m_118506_(TextureAtlas.f_118259_).m_117960_(false, false);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TextureAtlas.f_118259_);
        RenderSystem.m_69478_();
        RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.m_85836_();
        poseStack.m_85837_((double)pX, (double)pY, 100.0);
        poseStack.m_85841_(1.0f, -1.0f, 1.0f);
        poseStack.m_85841_((float)size, (float)size, (float)size);
        RenderSystem.m_157182_();
        MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
        Lighting.m_84930_();
        itemRenderer.m_115143_(itemStack, ItemTransforms.TransformType.GUI, false, poseStack, (MultiBufferSource)bufferSource, 0xF000F0, OverlayTexture.f_118083_, itemBakedModel);
        bufferSource.m_109911_();
        poseStack.m_85849_();
        RenderSystem.m_157182_();
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        super.m_7933_(keyCode, scanCode, modifiers);
        InputConstants.Key mouseKey = InputConstants.m_84827_((int)keyCode, (int)scanCode);
        if (this.f_96541_.f_91066_.f_92092_.isActiveAndMatches(mouseKey)) {
            this.m_7379_();
        }
        return true;
    }

    public static void open(ChessPieceFigureBlockEntity chessPieceFigureBlockEntity) {
        Minecraft.m_91087_().m_91152_((Screen)new ChessPieceFigureSettingsScreen(chessPieceFigureBlockEntity, false));
    }

    @Override
    public TTCColorPicker getColorPicker() {
        return this.colorPicker;
    }

    @Override
    public ForgeSlider getRedSlider() {
        return this.redColorSlider;
    }

    @Override
    public ForgeSlider getGreenSlider() {
        return this.greenColorSlider;
    }

    @Override
    public ForgeSlider getBlueSlider() {
        return this.blueColorSlider;
    }

    @Override
    public ForgeSlider getSaturationSlider() {
        return this.saturationSlider;
    }

    @Override
    public boolean isColorPickerActive() {
        return this.isColorPickerActive;
    }
}

