/*
 * Decompiled with CFR 0.152.
 */
package andrews.table_top_craft.screens.piece_figure.util;

import andrews.table_top_craft.screens.piece_figure.util.IColorPicker;
import andrews.table_top_craft.screens.piece_figure.util.IColorPickerExtended;
import andrews.table_top_craft.util.Color;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.client.gui.ScreenUtils;

public class TTCColorPicker
extends AbstractSliderButton {
    private static final ResourceLocation COLOR_CHART = new ResourceLocation("table_top_craft:textures/gui/color_picker/color_chart.png");
    private static final ResourceLocation SATURATION_CHART = new ResourceLocation("table_top_craft:textures/gui/color_picker/saturation_chart.png");
    private final Screen screen;
    private final Color color;
    private double valueY;

    public TTCColorPicker(int xPos, int yPos, Screen screen, double valueX, double valueY) {
        super(xPos, yPos, 128, 128, (Component)Component.m_237113_((String)""), valueX);
        this.screen = screen;
        this.valueY = valueY;
        this.color = new Color(0, 0, 0);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        float f;
        boolean flagY;
        boolean flagX = keyCode == 263;
        boolean bl = flagY = keyCode == 265;
        if (flagX || keyCode == 262) {
            f = flagX ? -1.0f : 1.0f;
            this.f_93577_ = this.snapToNearest(this.f_93577_ + (double)f * 0.0027777777777778);
            this.m_5695_();
            this.updateRGBHSVSliders();
        }
        if (flagY || keyCode == 264) {
            f = flagY ? -1.0f : 1.0f;
            this.valueY = this.snapToNearest(this.valueY + (double)f * 0.0027777777777778);
            this.m_5695_();
            this.updateRGBHSVSliders();
        }
        return false;
    }

    public void m_6303_(PoseStack pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
        pPoseStack.m_85836_();
        pPoseStack.m_85837_((double)this.f_93620_, (double)this.f_93621_, 0.0);
        pPoseStack.m_85841_(0.5f, 0.5f, 0.5f);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)COLOR_CHART);
        this.m_93228_(pPoseStack, 0, 0, 0, 0, 256, 256);
        RenderSystem.m_69478_();
        Screen screen = this.screen;
        if (screen instanceof IColorPicker) {
            IColorPicker colorPicker = (IColorPicker)screen;
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)(1.0f - (float)colorPicker.getSaturationSlider().getValueInt() / 100.0f));
        }
        RenderSystem.m_157456_((int)0, (ResourceLocation)SATURATION_CHART);
        this.m_93228_(pPoseStack, 0, 0, 0, 0, 256, 256);
        RenderSystem.m_69461_();
        pPoseStack.m_85849_();
        Minecraft mc = Minecraft.m_91087_();
        this.m_7906_(pPoseStack, mc, pMouseX, pMouseY);
    }

    public Color getColor() {
        float colorHue = (float)(this.f_93577_ * 360.0);
        float colorSaturation = 1.0f;
        Screen screen = this.screen;
        if (screen instanceof IColorPicker) {
            IColorPicker colorPicker = (IColorPicker)screen;
            colorSaturation = (float)colorPicker.getSaturationSlider().getValueInt() / 100.0f;
        }
        float colorValue = 1.0f - (float)this.valueY;
        return this.color.fromHSV(colorHue, colorSaturation, colorValue);
    }

    protected void m_7906_(PoseStack poseStack, Minecraft minecraft, int mouseX, int mouseY) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)f_93617_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int offset = (this.m_198029_() ? 2 : 1) * 20;
        int begTexOffset = 1;
        int destTexOffset = 2;
        int xPosition = this.f_93620_ + (int)(this.f_93577_ * (double)(this.f_93618_ - destTexOffset)) - begTexOffset;
        int yPosition = this.f_93621_ + (int)(this.valueY * (double)(this.f_93619_ - destTexOffset)) - begTexOffset;
        int size = 4;
        ScreenUtils.blitWithBorder((PoseStack)poseStack, (ResourceLocation)f_93617_, (int)xPosition, (int)yPosition, (int)0, (int)(46 + offset), (int)size, (int)size, (int)200, (int)20, (int)1, (int)1, (int)1, (int)1, (float)this.m_93252_());
    }

    protected void m_7212_(double mouseX, double mouseY, double dragX, double dragY) {
        super.m_7212_(mouseX, mouseY, dragX, dragY);
        this.setValueFromMouse(mouseX, mouseY);
    }

    private void setValueFromMouse(double mouseX, double mouseY) {
        this.setSliderValue((mouseX - (double)(this.f_93620_ + 1)) / (double)(this.f_93618_ - 2), (mouseY - (double)(this.f_93621_ + 1)) / (double)(this.f_93619_ - 2));
    }

    public void m_5716_(double mouseX, double mouseY) {
        this.setSliderValue((mouseX - (double)(this.f_93620_ + 1)) / (double)(this.f_93618_ - 2), (mouseY - (double)(this.f_93621_ + 1)) / (double)(this.f_93619_ - 2));
    }

    private void setSliderValue(double mouseX, double mouseY) {
        double oldValueX = this.f_93577_;
        double oldValueY = this.valueY;
        this.f_93577_ = this.snapToNearest(mouseX);
        if (!Mth.m_14082_((double)oldValueX, (double)this.f_93577_)) {
            this.m_5697_();
        }
        this.valueY = this.snapToNearest(mouseY);
        if (!Mth.m_14082_((double)oldValueY, (double)this.valueY)) {
            this.m_5697_();
        }
        this.m_5695_();
        this.updateRGBHSVSliders();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void updateRGBHSVSliders() {
        Color color = this.getColor();
        Screen screen = this.screen;
        if (screen instanceof IColorPicker) {
            IColorPicker colorPicker = (IColorPicker)screen;
            screen = this.screen;
            if (screen instanceof IColorPickerExtended) {
                IColorPickerExtended colorPickerExtended = (IColorPickerExtended)screen;
                if (colorPicker.isColorPickerActive()) {
                    colorPicker.getRedSlider().m_93611_((double)color.getRed());
                    colorPicker.getGreenSlider().m_93611_((double)color.getGreen());
                    colorPicker.getBlueSlider().m_93611_((double)color.getBlue());
                }
                if (!colorPickerExtended.isOptionalColorPickerActive()) return;
                colorPickerExtended.getOptionalRedSlider().m_93611_((double)color.getRed());
                colorPickerExtended.getOptionalGreenSlider().m_93611_((double)color.getGreen());
                colorPickerExtended.getOptionalBlueSlider().m_93611_((double)color.getBlue());
                return;
            }
        }
        if (!((screen = this.screen) instanceof IColorPicker)) return;
        IColorPicker colorPicker = (IColorPicker)screen;
        colorPicker.getRedSlider().m_93611_((double)color.getRed());
        colorPicker.getGreenSlider().m_93611_((double)color.getGreen());
        colorPicker.getBlueSlider().m_93611_((double)color.getBlue());
    }

    /*
     * Enabled aggressive block sorting
     */
    public void updateColorPickerFromSliders() {
        Screen red2;
        Screen screen = this.screen;
        if (screen instanceof IColorPicker) {
            IColorPicker colorPicker = (IColorPicker)screen;
            screen = this.screen;
            if (screen instanceof IColorPickerExtended) {
                IColorPickerExtended colorPickerExtended = (IColorPickerExtended)screen;
                int red2 = colorPicker.getRedSlider().getValueInt();
                int green = colorPicker.getGreenSlider().getValueInt();
                int blue = colorPicker.getBlueSlider().getValueInt();
                if (colorPickerExtended.isOptionalColorPickerActive()) {
                    red2 = colorPickerExtended.getOptionalRedSlider().getValueInt();
                    green = colorPickerExtended.getOptionalGreenSlider().getValueInt();
                    blue = colorPickerExtended.getOptionalBlueSlider().getValueInt();
                }
                Color color = new Color(red2, green, blue);
                this.setValueX(color.getHue());
                this.setValueY(1.0f - color.getValue());
                colorPicker.getSaturationSlider().m_93611_((double)(color.getSaturation() * 100.0f));
                return;
            }
        }
        if (!((red2 = this.screen) instanceof IColorPicker)) return;
        IColorPicker colorPicker = (IColorPicker)red2;
        int red2 = colorPicker.getRedSlider().getValueInt();
        int green = colorPicker.getGreenSlider().getValueInt();
        int blue = colorPicker.getBlueSlider().getValueInt();
        Color color = new Color(red2, green, blue);
        this.setValueX(color.getHue());
        this.setValueY(1.0f - color.getValue());
        colorPicker.getSaturationSlider().m_93611_((double)(color.getSaturation() * 100.0f));
    }

    private double snapToNearest(double value) {
        double stepSize = 0.0027777777777778;
        double minValue = 0.0;
        double maxValue = 1.0;
        value = Mth.m_14139_((double)Mth.m_14008_((double)value, (double)0.0, (double)1.0), (double)minValue, (double)maxValue);
        value = stepSize * (double)Math.round(value / stepSize);
        value = Mth.m_14008_((double)value, (double)minValue, (double)maxValue);
        return Mth.m_144914_((double)value, (double)minValue, (double)maxValue, (double)0.0, (double)1.0);
    }

    protected void m_5695_() {
        this.m_93666_((Component)Component.m_237113_((String)""));
    }

    public void setValueX(double value) {
        this.f_93577_ = this.snapToNearest(value /= 360.0);
        this.m_5695_();
    }

    public void setValueY(double value) {
        this.valueY = this.snapToNearest(value);
        this.m_5695_();
    }

    protected void m_5697_() {
    }
}

