/*
 * Decompiled with CFR 0.152.
 */
package andrews.table_top_craft.tile_entities.render;

import andrews.table_top_craft.game_logic.chess.pieces.BasePiece;
import andrews.table_top_craft.objects.blocks.ChessPieceFigureBlock;
import andrews.table_top_craft.tile_entities.ChessPieceFigureBlockEntity;
import andrews.table_top_craft.tile_entities.model.piece_figure.ChessPieceFigureStandModel;
import andrews.table_top_craft.tile_entities.render.BufferHelpers;
import andrews.table_top_craft.util.Color;
import andrews.table_top_craft.util.DrawScreenHelper;
import andrews.table_top_craft.util.NBTColorSaving;
import andrews.table_top_craft.util.TTCRenderTypes;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class ChessPieceFigureTileEntityRenderer
implements BlockEntityRenderer<ChessPieceFigureBlockEntity> {
    private static final NativeImage image = new NativeImage(NativeImage.Format.RGBA, 1, 1, true);
    private static final DynamicTexture texture = new DynamicTexture(image);
    private static ResourceLocation resourceLocation = null;
    public static final ResourceLocation CHESS_PIECE_FIGURE_TEXTURE = new ResourceLocation("table_top_craft", "textures/tile/chess_piece_figure/chess_piece_figure.png");
    private static ChessPieceFigureStandModel chessPieceFigureStandModel;
    private Color color = new Color(0, 0, 0);

    public ChessPieceFigureTileEntityRenderer(BlockEntityRendererProvider.Context context) {
        chessPieceFigureStandModel = new ChessPieceFigureStandModel(context.m_173582_(ChessPieceFigureStandModel.CHESS_PIECE_FIGURE_LAYER));
    }

    public void render(ChessPieceFigureBlockEntity blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        if (blockEntity.getPieceName() != null && blockEntity.getPieceName().equals("andrew_")) {
            int tickCount = Minecraft.m_91087_().f_91074_.f_19797_;
            int value = tickCount % 180 * 2;
            this.color = this.color.fromHSV(value, 1.0f, 1.0f);
            blockEntity.setPieceColor(this.color.getRed() + "/" + this.color.getGreen() + "/" + this.color.getBlue() + "/255");
        }
        ChessPieceFigureTileEntityRenderer.renderChessPieceFigure(blockEntity, poseStack, bufferSource, false, false, partialTicks, packedLight, packedOverlay);
    }

    public static void renderChessPieceFigure(ChessPieceFigureBlockEntity blockEntity, PoseStack poseStack, MultiBufferSource bufferSource, boolean isInGui, boolean isHeldOrHead, float partialTicks, int packedLight, int packedOverlay) {
        BlockState blockstate;
        Matrix4f initialMatrix = poseStack.m_85850_().m_85861_();
        if (!blockEntity.m_58898_()) {
            poseStack.m_85836_();
            poseStack.m_85837_(0.5, 1.5, 0.5);
            poseStack.m_85841_(1.0f, -1.0f, -1.0f);
            if (blockEntity.getRotateChessPieceFigure() && isInGui) {
                poseStack.m_85845_(Vector3f.f_122225_.m_122240_((float)Minecraft.m_91087_().f_91074_.f_19797_ + partialTicks));
            }
            VertexConsumer vertexconsumer = bufferSource.m_6299_(RenderType.m_110446_((ResourceLocation)CHESS_PIECE_FIGURE_TEXTURE));
            chessPieceFigureStandModel.m_7695_(poseStack, vertexconsumer, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
            poseStack.m_85849_();
        }
        int rotation = 0;
        if (blockEntity.m_58898_() && (blockstate = blockEntity.m_58904_().m_8055_(blockEntity.m_58899_())).m_60734_() instanceof ChessPieceFigureBlock) {
            rotation = (Integer)blockstate.m_61143_((Property)ChessPieceFigureBlock.ROTATION);
        }
        int lightU = LightTexture.m_109883_((int)packedLight);
        int lightV = LightTexture.m_109894_((int)packedLight);
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 0.125, 0.5);
        poseStack.m_85845_(Vector3f.f_122224_.m_122240_((float)rotation * 22.5f));
        if (blockEntity.getRotateChessPieceFigure()) {
            poseStack.m_85845_(Vector3f.f_122224_.m_122240_((float)Minecraft.m_91087_().f_91074_.f_19797_ + partialTicks));
        }
        poseStack.m_85841_(3.0f, -3.0f, -3.0f);
        if (blockEntity.getPieceName() != null && blockEntity.getPieceName().equals("Lyzantra")) {
            poseStack.m_85837_(0.0, -0.2 * blockEntity.getPieceScale(), 0.0);
            poseStack.m_85845_(Vector3f.f_122226_.m_122240_(180.0f));
        }
        if (blockEntity.m_58898_()) {
            float scale = (float)blockEntity.getPieceScale();
            poseStack.m_85841_(scale, scale, scale);
        }
        poseStack.m_85836_();
        RenderType type = TTCRenderTypes.getChessPieceSolid(resourceLocation);
        type.m_110185_();
        ShaderInstance shaderinstance = RenderSystem.m_157196_();
        if (shaderinstance.f_173309_ != null) {
            shaderinstance.f_173309_.m_5679_(RenderSystem.m_157192_());
        }
        BufferHelpers.setupRender(RenderSystem.m_157196_(), lightU, lightV);
        float red = (float)NBTColorSaving.getRed(blockEntity.getPieceColor()) / 255.0f;
        float green = (float)NBTColorSaving.getGreen(blockEntity.getPieceColor()) / 255.0f;
        float blue = (float)NBTColorSaving.getBlue(blockEntity.getPieceColor()) / 255.0f;
        BufferHelpers.updateColor(shaderinstance, new float[]{red, green, blue, 1.0f});
        poseStack.m_85836_();
        if (shaderinstance.f_173308_ != null) {
            if (isInGui || isHeldOrHead) {
                Matrix4f mat4f = RenderSystem.m_157190_().m_27658_();
                PoseStack stk = new PoseStack();
                stk.m_85850_().m_85861_().m_27644_(mat4f);
                stk.m_85850_().m_85861_().m_27644_(initialMatrix);
                stk.m_85837_(0.5, 0.125, 0.5);
                if (blockEntity.getRotateChessPieceFigure()) {
                    stk.m_85845_(Vector3f.f_122224_.m_122240_((float)Minecraft.m_91087_().f_91074_.f_19797_ + partialTicks));
                }
                if (blockEntity.getPieceName() != null && blockEntity.getPieceName().equals("Lyzantra")) {
                    stk.m_85837_(0.0, 0.85, 0.0);
                    stk.m_85845_(Vector3f.f_122226_.m_122240_(180.0f));
                }
                stk.m_85841_(isHeldOrHead ? 3.0f : 4.0f, isHeldOrHead ? -3.0f : -4.0f, isHeldOrHead ? -3.0f : -4.0f);
                shaderinstance.f_173308_.m_5679_(stk.m_85850_().m_85861_());
            } else {
                shaderinstance.f_173308_.m_5679_(poseStack.m_85850_().m_85861_());
            }
        }
        BasePiece.PieceModelSet set = BasePiece.PieceModelSet.get(blockEntity.getPieceSet());
        BasePiece.PieceType piece = BasePiece.PieceType.get(blockEntity.getPieceType());
        VertexBuffer pawnBuffer = DrawScreenHelper.getBuffer(set, piece);
        TTCRenderTypes.getChessPieceSolid(resourceLocation).m_110185_();
        BufferHelpers.draw(pawnBuffer);
        VertexBuffer.m_85931_();
        shaderinstance.m_173362_();
        type.m_110188_();
        poseStack.m_85849_();
        poseStack.m_85849_();
        poseStack.m_85849_();
    }

    static {
        image.m_84988_(0, 0, 0xFFFFFF);
        texture.m_117985_();
        resourceLocation = Minecraft.m_91087_().m_91097_().m_118490_("table_top_craft_dummy", texture);
    }
}

