/*
 * Decompiled with CFR 0.152.
 */
package andrews.table_top_craft.tile_entities.render;

import andrews.table_top_craft.game_logic.chess.PieceColor;
import andrews.table_top_craft.game_logic.chess.board.Board;
import andrews.table_top_craft.game_logic.chess.board.ChessMoveLog;
import andrews.table_top_craft.game_logic.chess.board.moves.BaseMove;
import andrews.table_top_craft.game_logic.chess.pieces.BasePiece;
import andrews.table_top_craft.game_logic.chess.player.BlackChessPlayer;
import andrews.table_top_craft.game_logic.chess.player.MoveTransition;
import andrews.table_top_craft.game_logic.chess.player.WhiteChessPlayer;
import andrews.table_top_craft.objects.blocks.ChessBlock;
import andrews.table_top_craft.tile_entities.ChessTileEntity;
import andrews.table_top_craft.tile_entities.model.chess.ChessBoardPlateModel;
import andrews.table_top_craft.tile_entities.model.chess.ChessHighlightModel;
import andrews.table_top_craft.tile_entities.model.chess.ChessTilesInfoModel;
import andrews.table_top_craft.tile_entities.render.BufferHelpers;
import andrews.table_top_craft.util.DrawScreenHelper;
import andrews.table_top_craft.util.NBTColorSaving;
import andrews.table_top_craft.util.TTCRenderTypes;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class ChessTileEntityRenderer
implements BlockEntityRenderer<ChessTileEntity> {
    private static final ResourceLocation HIGHLIGHT_TEXTURE = new ResourceLocation("table_top_craft", "textures/tile/chess/highlight.png");
    private static final ResourceLocation TILES_INFO_TEXTURE = new ResourceLocation("table_top_craft", "textures/tile/chess/chess_tiles_info.png");
    private static final ResourceLocation PLATE_WHITE_TILES_TEXTURE = new ResourceLocation("table_top_craft", "textures/tile/chess/plate_white_tiles.png");
    private static final ResourceLocation PLATE_BLACK_TILES_TEXTURE = new ResourceLocation("table_top_craft", "textures/tile/chess/plate_black_tiles.png");
    private static final float CHESS_SCALE = 0.125f;
    private final float CHESS_PIECE_SCALE = 0.1f;
    private static final NativeImage image = new NativeImage(NativeImage.Format.RGBA, 1, 1, true);
    private static final DynamicTexture texture = new DynamicTexture(image);
    private static ResourceLocation resourceLocation = null;
    private final ChessHighlightModel highlightModel;
    private final ChessTilesInfoModel tilesInfoModel;
    private final ChessBoardPlateModel chessBoardPlateModel;
    private final List<Integer> destinationCoordinates = new ArrayList<Integer>();
    private final List<BasePiece> whiteTakenPieces = new ArrayList<BasePiece>();
    private final List<BasePiece> blackTakenPieces = new ArrayList<BasePiece>();

    public ChessTileEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.highlightModel = new ChessHighlightModel(context.m_173582_(ChessHighlightModel.CHESS_HIGHLIGHT_LAYER));
        this.tilesInfoModel = new ChessTilesInfoModel(context.m_173582_(ChessTilesInfoModel.CHESS_TILES_INFO_LAYER));
        this.chessBoardPlateModel = new ChessBoardPlateModel(context.m_173582_(ChessBoardPlateModel.CHESS_BOARD_PLATE_LAYER));
    }

    public void render(ChessTileEntity tileEntityIn, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        BlockState blockstate;
        Direction facing = Direction.NORTH;
        if (tileEntityIn.m_58898_() && (blockstate = tileEntityIn.m_58904_().m_8055_(tileEntityIn.m_58899_())).m_60734_() instanceof ChessBlock) {
            facing = (Direction)blockstate.m_61143_((Property)ChessBlock.FACING);
        }
        int lightU = LightTexture.m_109883_((int)combinedLightIn);
        int lightV = LightTexture.m_109894_((int)combinedLightIn);
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 0.9, 0.5);
        poseStack.m_85841_(1.0f, -1.0f, -1.0f);
        switch (facing) {
            default: {
                poseStack.m_85845_(Vector3f.f_122224_.m_122240_(180.0f));
                break;
            }
            case SOUTH: {
                break;
            }
            case WEST: {
                poseStack.m_85845_(Vector3f.f_122224_.m_122240_(270.0f));
                break;
            }
            case EAST: {
                poseStack.m_85845_(Vector3f.f_122224_.m_122240_(90.0f));
            }
        }
        if (tileEntityIn.getUseCustomPlate()) {
            this.renderChessBoardPlate(poseStack, bufferIn, combinedLightIn, combinedOverlayIn, tileEntityIn);
        }
        if (tileEntityIn.getShouldShowTileInfo()) {
            this.renderTilesInfo(poseStack, bufferIn, combinedLightIn, combinedOverlayIn, tileEntityIn);
        }
        poseStack.m_85849_();
        if (tileEntityIn.getBoard() != null) {
            int column;
            int rank;
            Board board = tileEntityIn.getBoard();
            WhiteChessPlayer whiteChessPlayer = (WhiteChessPlayer)board.getWhiteChessPlayer();
            BlackChessPlayer blackChessPlayer = (BlackChessPlayer)board.getBlackChessPlayer();
            boolean isWhiteInCheckmate = whiteChessPlayer.isInCheckMate();
            boolean isBlackInCheckmate = blackChessPlayer.isInCheckMate();
            poseStack.m_85836_();
            poseStack.m_85837_(0.5, 0.9, 0.5);
            poseStack.m_85841_(1.0f, -1.0f, -1.0f);
            switch (facing) {
                default: {
                    poseStack.m_85845_(Vector3f.f_122224_.m_122240_(180.0f));
                    break;
                }
                case SOUTH: {
                    break;
                }
                case WEST: {
                    poseStack.m_85845_(Vector3f.f_122224_.m_122240_(270.0f));
                    break;
                }
                case EAST: {
                    poseStack.m_85845_(Vector3f.f_122224_.m_122240_(90.0f));
                }
            }
            poseStack.m_85837_(0.0625, 0.0, 0.0625);
            poseStack.m_85837_(0.375, 0.0, -0.5);
            int currentCoordinate = -1;
            poseStack.m_85836_();
            float wR = (float)NBTColorSaving.getRed(tileEntityIn.getWhitePiecesColor()) / 255.0f;
            float wG = (float)NBTColorSaving.getGreen(tileEntityIn.getWhitePiecesColor()) / 255.0f;
            float wB = (float)NBTColorSaving.getBlue(tileEntityIn.getWhitePiecesColor()) / 255.0f;
            float bR = (float)NBTColorSaving.getRed(tileEntityIn.getBlackPiecesColor()) / 255.0f;
            float bG = (float)NBTColorSaving.getGreen(tileEntityIn.getBlackPiecesColor()) / 255.0f;
            float bB = (float)NBTColorSaving.getBlue(tileEntityIn.getBlackPiecesColor()) / 255.0f;
            RenderType type = TTCRenderTypes.getChessPieceSolid(resourceLocation);
            type.m_110185_();
            ShaderInstance shaderinstance = RenderSystem.m_157196_();
            if (shaderinstance.f_173309_ != null) {
                shaderinstance.f_173309_.m_5679_(RenderSystem.m_157192_());
            }
            BufferHelpers.setupRender(RenderSystem.m_157196_(), lightU, lightV);
            for (rank = 0; rank < 8; ++rank) {
                for (column = 0; column < 8; ++column) {
                    boolean isSelectedPiece;
                    boolean bl = isSelectedPiece = board.getTile(++currentCoordinate) == tileEntityIn.getSourceTile() && tileEntityIn.getHumanMovedPiece() != null;
                    if (board.getTile(currentCoordinate).isTileOccupied()) {
                        PieceColor pieceColor = board.getTile(currentCoordinate).getPiece().getPieceColor();
                        BasePiece.PieceType pieceType = board.getTile(currentCoordinate).getPiece().getPieceType();
                        poseStack.m_85836_();
                        poseStack.m_85837_((double)(0.125f * (float)(-column)), 0.0, (double)(0.125f * (float)rank));
                        if (isSelectedPiece) {
                            RenderSystem.m_69860_((int)1032, (int)6913);
                            RenderSystem.m_69832_((float)2.0f);
                        }
                        poseStack.m_85836_();
                        poseStack.m_85837_(0.0, 0.15, 0.0);
                        if (pieceColor.isWhite()) {
                            poseStack.m_85845_(Vector3f.f_122224_.m_122240_(180.0f));
                        }
                        if (isWhiteInCheckmate && pieceColor.isBlack()) {
                            poseStack.m_85837_(0.0, (double)((float)Math.abs(Math.sin((double)((float)Minecraft.m_91087_().f_91074_.f_19797_ + partialTicks) / 2.5)) * -0.05f), 0.0);
                            poseStack.m_85845_(Vector3f.f_122226_.m_122240_((float)Math.cos((double)((float)Minecraft.m_91087_().f_91074_.f_19797_ + partialTicks) / 2.5) * 10.0f));
                        }
                        if (isBlackInCheckmate && pieceColor.isWhite()) {
                            poseStack.m_85837_(0.0, (double)((float)Math.abs(Math.sin((double)((float)Minecraft.m_91087_().f_91074_.f_19797_ + partialTicks) / 2.5)) * -0.05f), 0.0);
                            poseStack.m_85845_(Vector3f.f_122226_.m_122240_((float)Math.cos((double)((float)Minecraft.m_91087_().f_91074_.f_19797_ + partialTicks) / 2.5) * 10.0f));
                        }
                        this.renderPiece(poseStack, tileEntityIn.getPieceSet(), pieceType, pieceColor, wR, wG, wB, bR, bG, bB);
                        poseStack.m_85849_();
                        poseStack.m_85849_();
                    }
                    if (!isSelectedPiece) continue;
                    RenderSystem.m_69860_((int)1032, (int)6914);
                }
            }
            poseStack.m_85837_(-0.8125, 0.556, 0.0375);
            this.renderTakenPieces(poseStack, tileEntityIn.getMoveLog(), tileEntityIn);
            VertexBuffer.m_85931_();
            shaderinstance.m_173362_();
            type.m_110188_();
            poseStack.m_85849_();
            currentCoordinate = -1;
            for (rank = 0; rank < 8; ++rank) {
                for (column = 0; column < 8; ++column) {
                    ++currentCoordinate;
                    poseStack.m_85836_();
                    poseStack.m_85837_((double)(0.125f * (float)(-column)), 0.0, (double)(0.125f * (float)rank));
                    if (tileEntityIn.getShowPreviousMove() && tileEntityIn.getMoveLog().getMoves().size() > 0) {
                        BaseMove lastMove = tileEntityIn.getMoveLog().getMoves().get(tileEntityIn.getMoveLog().getMoves().size() - 1);
                        for (BaseMove move : this.pieceLegalMoves(tileEntityIn)) {
                            this.destinationCoordinates.add(move.getDestinationCoordinate());
                        }
                        if (!(lastMove.getCurrentCoordinate() != currentCoordinate || this.destinationCoordinates.contains(lastMove.getCurrentCoordinate()) && tileEntityIn.getShowAvailableMoves())) {
                            this.renderHighlight(poseStack, bufferIn, combinedLightIn, combinedOverlayIn, HighlightType.LAST_MADE_MOVE, tileEntityIn);
                        }
                        if (!(lastMove.getDestinationCoordinate() != currentCoordinate || this.destinationCoordinates.contains(lastMove.getDestinationCoordinate()) && tileEntityIn.getShowAvailableMoves())) {
                            this.renderHighlight(poseStack, bufferIn, combinedLightIn, combinedOverlayIn, HighlightType.LAST_MADE_MOVE, tileEntityIn);
                        }
                        this.destinationCoordinates.clear();
                    }
                    if (tileEntityIn.getShowAvailableMoves()) {
                        if (!(tileEntityIn.getHumanMovedPiece() == null || tileEntityIn.getHumanMovedPiece().getPieceColor() != tileEntityIn.getBoard().getCurrentChessPlayer().getPieceColor() || tileEntityIn.getCachedPiece() != null && tileEntityIn.getCachedPiece().equals(tileEntityIn.getHumanMovedPiece()))) {
                            tileEntityIn.clearMoveTransitionsCache();
                            for (BaseMove move : this.pieceLegalMoves(tileEntityIn)) {
                                MoveTransition transition = board.getCurrentChessPlayer().makeMove(move);
                                tileEntityIn.addToMoveTransitionsCache(transition);
                            }
                            tileEntityIn.setCachedPiece(tileEntityIn.getHumanMovedPiece());
                        }
                        block20: for (int i = 0; i < this.pieceLegalMoves(tileEntityIn).size(); ++i) {
                            MoveTransition transition;
                            BaseMove move;
                            if (tileEntityIn.getMoveTransitionsCache().isEmpty() || (move = (transition = tileEntityIn.getMoveTransitionsCache().get(i)).getMove()).getDestinationCoordinate() != currentCoordinate) continue;
                            if (move.isCastlingMove()) {
                                this.renderHighlight(poseStack, bufferIn, combinedLightIn, combinedOverlayIn, HighlightType.CASTLE_MOVE, tileEntityIn);
                                continue;
                            }
                            switch (transition.getMoveStatus()) {
                                case DONE: {
                                    this.renderHighlight(poseStack, bufferIn, combinedLightIn, combinedOverlayIn, move.isAttack() ? HighlightType.ATTACK_MOVE : HighlightType.LEGAL_MOVE, tileEntityIn);
                                    continue block20;
                                }
                                case LEAVES_PLAYER_IN_CHECK: {
                                    this.renderHighlight(poseStack, bufferIn, combinedLightIn, combinedOverlayIn, HighlightType.LEAVES_PLAYER_IN_CHECK, tileEntityIn);
                                }
                            }
                        }
                    }
                    poseStack.m_85849_();
                }
            }
            poseStack.m_85849_();
        }
    }

    private void renderTakenPieces(PoseStack stack, ChessMoveLog moveLog, ChessTileEntity chessTileEntity) {
        for (BaseMove move : moveLog.getMoves()) {
            if (!move.isAttack()) continue;
            BasePiece takenPiece = move.getAttackedPiece();
            if (takenPiece.getPieceColor().isWhite()) {
                this.whiteTakenPieces.add(takenPiece);
                continue;
            }
            if (takenPiece.getPieceColor().isBlack()) {
                this.blackTakenPieces.add(takenPiece);
                continue;
            }
            throw new RuntimeException("Attempted to get a Piece that had no PieceColor");
        }
        this.whiteTakenPieces.sort((piece1, piece2) -> Ints.compare((int)piece2.getPieceValue(), (int)piece1.getPieceValue()));
        this.blackTakenPieces.sort((piece1, piece2) -> Ints.compare((int)piece2.getPieceValue(), (int)piece1.getPieceValue()));
        this.renderTakenPiecesFigures(stack, chessTileEntity, this.whiteTakenPieces, true);
        this.renderTakenPiecesFigures(stack, chessTileEntity, this.blackTakenPieces, false);
        this.whiteTakenPieces.clear();
        this.blackTakenPieces.clear();
    }

    private void renderTakenPiecesFigures(PoseStack stack, ChessTileEntity chessTileEntity, List<BasePiece> pieceList, boolean isWhite) {
        int currentCoordinate = -1;
        int currentRank = 0;
        float wR = (float)NBTColorSaving.getRed(chessTileEntity.getWhitePiecesColor()) / 255.0f;
        float wG = (float)NBTColorSaving.getGreen(chessTileEntity.getWhitePiecesColor()) / 255.0f;
        float wB = (float)NBTColorSaving.getBlue(chessTileEntity.getWhitePiecesColor()) / 255.0f;
        float bR = (float)NBTColorSaving.getRed(chessTileEntity.getBlackPiecesColor()) / 255.0f;
        float bG = (float)NBTColorSaving.getGreen(chessTileEntity.getBlackPiecesColor()) / 255.0f;
        float bB = (float)NBTColorSaving.getBlue(chessTileEntity.getBlackPiecesColor()) / 255.0f;
        for (BasePiece piece : pieceList) {
            if (currentCoordinate < 7) {
                ++currentCoordinate;
            } else {
                currentCoordinate = 0;
                ++currentRank;
            }
            stack.m_85836_();
            if (isWhite) {
                stack.m_85845_(Vector3f.f_122224_.m_122240_(180.0f));
            }
            if (!isWhite) {
                stack.m_85837_(0.7481249999999999, 0.0, 0.8);
            }
            stack.m_85837_(0.106875 * (double)(-currentCoordinate), 0.0, (double)(0.125f * (float)(-currentRank)));
            this.renderPiece(stack, chessTileEntity.getPieceSet(), piece.getPieceType(), piece.getPieceColor(), wR, wG, wB, bR, bG, bB);
            stack.m_85849_();
        }
    }

    private void renderPiece(PoseStack poseStack, int pieceModelSet, BasePiece.PieceType pieceType, PieceColor pieceColor, float wR, float wG, float wB, float bR, float bG, float bB) {
        ShaderInstance shaderinstance = RenderSystem.m_157196_();
        BufferHelpers.updateColor(shaderinstance, new float[]{pieceColor.isWhite() ? wR : bR, pieceColor.isWhite() ? wG : bG, pieceColor.isWhite() ? wB : bB, 1.0f});
        poseStack.m_85836_();
        if (shaderinstance.f_173308_ != null) {
            shaderinstance.f_173308_.m_5679_(poseStack.m_85850_().m_85861_());
        }
        BasePiece.PieceModelSet set = BasePiece.PieceModelSet.get(pieceModelSet + 1);
        VertexBuffer pawnBuffer = DrawScreenHelper.getBuffer(set, pieceType);
        BufferHelpers.draw(pawnBuffer);
        poseStack.m_85849_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private Collection<BaseMove> pieceLegalMoves(ChessTileEntity chessTileEntity) {
        if (chessTileEntity.getHumanMovedPiece() != null && chessTileEntity.getHumanMovedPiece().getPieceColor() == chessTileEntity.getBoard().getCurrentChessPlayer().getPieceColor()) {
            ArrayList<BaseMove> pieceMoves = new ArrayList<BaseMove>();
            for (BaseMove move : chessTileEntity.getBoard().getCurrentChessPlayer().getLegalMoves()) {
                if (move.getMovedPiece() != chessTileEntity.getHumanMovedPiece()) continue;
                pieceMoves.add(move);
            }
            return ImmutableList.copyOf(pieceMoves);
        }
        return Collections.emptyList();
    }

    private void renderHighlight(PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn, HighlightType highlightType, ChessTileEntity chessTileEntity) {
        VertexConsumer builderHighlight = bufferIn.m_6299_(TTCRenderTypes.getEmissiveTransluscent(HIGHLIGHT_TEXTURE, false));
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, (double)-1.345f, 0.0);
        poseStack.m_85841_(1.0f, 1.0f, 1.0f);
        switch (highlightType) {
            default: {
                float R = (float)NBTColorSaving.getRed(chessTileEntity.getLegalMoveColor()) / 255.0f;
                float G = (float)NBTColorSaving.getGreen(chessTileEntity.getLegalMoveColor()) / 255.0f;
                float B = (float)NBTColorSaving.getBlue(chessTileEntity.getLegalMoveColor()) / 255.0f;
                float A = (float)NBTColorSaving.getAlpha(chessTileEntity.getLegalMoveColor()) / 255.0f;
                this.highlightModel.m_7695_(poseStack, builderHighlight, combinedLightIn, combinedOverlayIn, R, G, B, A);
                break;
            }
            case LEAVES_PLAYER_IN_CHECK: {
                float R1 = (float)NBTColorSaving.getRed(chessTileEntity.getInvalidMoveColor()) / 255.0f;
                float G1 = (float)NBTColorSaving.getGreen(chessTileEntity.getInvalidMoveColor()) / 255.0f;
                float B1 = (float)NBTColorSaving.getBlue(chessTileEntity.getInvalidMoveColor()) / 255.0f;
                float A1 = (float)NBTColorSaving.getAlpha(chessTileEntity.getInvalidMoveColor()) / 255.0f;
                this.highlightModel.m_7695_(poseStack, builderHighlight, combinedLightIn, combinedOverlayIn, R1, G1, B1, A1);
                break;
            }
            case CASTLE_MOVE: {
                float R2 = (float)NBTColorSaving.getRed(chessTileEntity.getCastleMoveColor()) / 255.0f;
                float G2 = (float)NBTColorSaving.getGreen(chessTileEntity.getCastleMoveColor()) / 255.0f;
                float B2 = (float)NBTColorSaving.getBlue(chessTileEntity.getCastleMoveColor()) / 255.0f;
                float A2 = (float)NBTColorSaving.getAlpha(chessTileEntity.getCastleMoveColor()) / 255.0f;
                this.highlightModel.m_7695_(poseStack, builderHighlight, combinedLightIn, combinedOverlayIn, R2, G2, B2, A2);
                break;
            }
            case ATTACK_MOVE: {
                float R3 = (float)NBTColorSaving.getRed(chessTileEntity.getAttackMoveColor()) / 255.0f;
                float G3 = (float)NBTColorSaving.getGreen(chessTileEntity.getAttackMoveColor()) / 255.0f;
                float B3 = (float)NBTColorSaving.getBlue(chessTileEntity.getAttackMoveColor()) / 255.0f;
                float A3 = (float)NBTColorSaving.getAlpha(chessTileEntity.getAttackMoveColor()) / 255.0f;
                this.highlightModel.m_7695_(poseStack, builderHighlight, combinedLightIn, combinedOverlayIn, R3, G3, B3, A3);
                break;
            }
            case LAST_MADE_MOVE: {
                float R4 = (float)NBTColorSaving.getRed(chessTileEntity.getPreviousMoveColor()) / 255.0f;
                float G4 = (float)NBTColorSaving.getGreen(chessTileEntity.getPreviousMoveColor()) / 255.0f;
                float B4 = (float)NBTColorSaving.getBlue(chessTileEntity.getPreviousMoveColor()) / 255.0f;
                float A4 = (float)NBTColorSaving.getAlpha(chessTileEntity.getPreviousMoveColor()) / 255.0f;
                this.highlightModel.m_7695_(poseStack, builderHighlight, combinedLightIn, combinedOverlayIn, R4, G4, B4, A4);
            }
        }
        poseStack.m_85849_();
    }

    private void renderTilesInfo(PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn, ChessTileEntity chessTileEntity) {
        VertexConsumer builderTilesInfo = bufferIn.m_6299_(TTCRenderTypes.getEmissiveTransluscent(TILES_INFO_TEXTURE, false));
        float red = (float)NBTColorSaving.getRed(chessTileEntity.getTileInfoColor()) / 255.0f;
        float green = (float)NBTColorSaving.getGreen(chessTileEntity.getTileInfoColor()) / 255.0f;
        float blue = (float)NBTColorSaving.getBlue(chessTileEntity.getTileInfoColor()) / 255.0f;
        poseStack.m_85836_();
        poseStack.m_85845_(Vector3f.f_122224_.m_122240_(180.0f));
        poseStack.m_85837_(0.0, (double)-1.32f, 0.0);
        this.tilesInfoModel.m_7695_(poseStack, builderTilesInfo, combinedLightIn, combinedOverlayIn, red, green, blue, 1.0f);
        poseStack.m_85849_();
    }

    private void renderChessBoardPlate(PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn, ChessTileEntity chessTileEntity) {
        float whiteR = (float)NBTColorSaving.getRed(chessTileEntity.getWhiteTilesColor()) / 255.0f;
        float whiteG = (float)NBTColorSaving.getGreen(chessTileEntity.getWhiteTilesColor()) / 255.0f;
        float whiteB = (float)NBTColorSaving.getBlue(chessTileEntity.getWhiteTilesColor()) / 255.0f;
        float blackR = (float)NBTColorSaving.getRed(chessTileEntity.getBlackTilesColor()) / 255.0f;
        float blackG = (float)NBTColorSaving.getGreen(chessTileEntity.getBlackTilesColor()) / 255.0f;
        float blackB = (float)NBTColorSaving.getBlue(chessTileEntity.getBlackTilesColor()) / 255.0f;
        VertexConsumer builderBoardPlateWhiteTiles = bufferIn.m_6299_(RenderType.m_110452_((ResourceLocation)PLATE_WHITE_TILES_TEXTURE));
        poseStack.m_85836_();
        poseStack.m_85845_(new Quaternion(180.0f, 270.0f, 0.0f, true));
        poseStack.m_85837_(0.0, -1.65, 0.0);
        this.chessBoardPlateModel.m_7695_(poseStack, builderBoardPlateWhiteTiles, combinedLightIn, combinedOverlayIn, whiteR, whiteG, whiteB, 1.0f);
        poseStack.m_85849_();
        VertexConsumer builderBoardPlateBlackTiles = bufferIn.m_6299_(RenderType.m_110452_((ResourceLocation)PLATE_BLACK_TILES_TEXTURE));
        poseStack.m_85836_();
        poseStack.m_85845_(new Quaternion(180.0f, 270.0f, 0.0f, true));
        poseStack.m_85837_(0.0, -1.65, 0.0);
        this.chessBoardPlateModel.m_7695_(poseStack, builderBoardPlateBlackTiles, combinedLightIn, combinedOverlayIn, blackR, blackG, blackB, 1.0f);
        poseStack.m_85849_();
    }

    static {
        image.m_84988_(0, 0, 0xFFFFFF);
        texture.m_117985_();
        resourceLocation = Minecraft.m_91087_().m_91097_().m_118490_("table_top_craft_dummy", texture);
    }

    static enum HighlightType {
        LEGAL_MOVE,
        LEAVES_PLAYER_IN_CHECK,
        CASTLE_MOVE,
        ATTACK_MOVE,
        LAST_MADE_MOVE;

    }
}

