/*
 * Decompiled with CFR 0.152.
 */
package andrews.table_top_craft.tile_entities.render;

import andrews.table_top_craft.tile_entities.TicTacToeBlockEntity;
import andrews.table_top_craft.tile_entities.model.tic_tac_toe.TicTacToeModel;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.resources.ResourceLocation;

public class TicTacToeBlockEntityRenderer
implements BlockEntityRenderer<TicTacToeBlockEntity> {
    private static final ArrayList<ResourceLocation> CIRCLE_TEXTURES = new ArrayList();
    private static final ArrayList<ResourceLocation> CROSS_TEXTURES = new ArrayList();
    private final TicTacToeModel ticTacToeModel;

    public TicTacToeBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        int i;
        for (i = 0; i < 16; ++i) {
            CIRCLE_TEXTURES.add(new ResourceLocation("table_top_craft", "textures/tile/tic_tac_toe/o/o_" + i + ".png"));
        }
        for (i = 0; i < 14; ++i) {
            CROSS_TEXTURES.add(new ResourceLocation("table_top_craft", "textures/tile/tic_tac_toe/x/x_" + i + ".png"));
        }
        this.ticTacToeModel = new TicTacToeModel(context.m_173582_(TicTacToeModel.TIC_TAC_TOE_LAYER));
    }

    public void render(TicTacToeBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 1.5, 0.5);
        poseStack.m_85841_(1.0f, -1.0f, -1.0f);
        poseStack.m_85837_(0.0, (double)-0.031746f, 0.0);
        poseStack.m_85841_(0.5f, 1.0f, 0.5f);
        String game = blockEntity.getTicTacToeGame();
        String[] rows = game.split("/");
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (blockEntity.isGameOver(game)) {
            poseStack.m_85836_();
            poseStack.m_85837_(0.0, -0.001, 0.0);
            VertexConsumer vertexconsumer = bufferSource.m_6299_(RenderType.m_110452_((ResourceLocation)CROSS_TEXTURES.get(6)));
            if (rows[0].equals("XXX") || rows[0].equals("OOO")) {
                poseStack.m_85837_(0.6, 0.0, 0.0);
                poseStack.m_85841_(1.0f, 1.0f, 3.8f);
                this.ticTacToeModel.m_7695_(poseStack, vertexconsumer, packedLight, packedOverlay, 0.0f, 0.0f, 0.0f, 1.0f);
            } else if (rows[1].equals("XXX") || rows[1].equals("OOO")) {
                poseStack.m_85841_(1.0f, 1.0f, 3.8f);
                this.ticTacToeModel.m_7695_(poseStack, vertexconsumer, packedLight, packedOverlay, 0.0f, 0.0f, 0.0f, 1.0f);
            } else if (rows[2].equals("XXX") || rows[2].equals("OOO")) {
                poseStack.m_85837_(-0.6, 0.0, 0.0);
                poseStack.m_85841_(1.0f, 1.0f, 3.8f);
                this.ticTacToeModel.m_7695_(poseStack, vertexconsumer, packedLight, packedOverlay, 0.0f, 0.0f, 0.0f, 1.0f);
            } else if (rows[0].charAt(0) == 'X' && rows[1].charAt(0) == 'X' && rows[2].charAt(0) == 'X' || rows[0].charAt(0) == 'O' && rows[1].charAt(0) == 'O' && rows[2].charAt(0) == 'O') {
                poseStack.m_85837_(0.0, 0.0, 0.6);
                poseStack.m_85845_(Vector3f.f_122224_.m_122240_(90.0f));
                poseStack.m_85841_(1.0f, 1.0f, 3.8f);
                this.ticTacToeModel.m_7695_(poseStack, vertexconsumer, packedLight, packedOverlay, 0.0f, 0.0f, 0.0f, 1.0f);
            } else if (rows[0].charAt(1) == 'X' && rows[1].charAt(1) == 'X' && rows[2].charAt(1) == 'X' || rows[0].charAt(1) == 'O' && rows[1].charAt(1) == 'O' && rows[2].charAt(1) == 'O') {
                poseStack.m_85845_(Vector3f.f_122224_.m_122240_(90.0f));
                poseStack.m_85841_(1.0f, 1.0f, 3.8f);
                this.ticTacToeModel.m_7695_(poseStack, vertexconsumer, packedLight, packedOverlay, 0.0f, 0.0f, 0.0f, 1.0f);
            } else if (rows[0].charAt(2) == 'X' && rows[1].charAt(2) == 'X' && rows[2].charAt(2) == 'X' || rows[0].charAt(2) == 'O' && rows[1].charAt(2) == 'O' && rows[2].charAt(2) == 'O') {
                poseStack.m_85837_(0.0, 0.0, -0.6);
                poseStack.m_85845_(Vector3f.f_122224_.m_122240_(90.0f));
                poseStack.m_85841_(1.0f, 1.0f, 3.8f);
                this.ticTacToeModel.m_7695_(poseStack, vertexconsumer, packedLight, packedOverlay, 0.0f, 0.0f, 0.0f, 1.0f);
            } else if (rows[0].charAt(0) == 'X' && rows[1].charAt(1) == 'X' && rows[2].charAt(2) == 'X' || rows[0].charAt(0) == 'O' && rows[1].charAt(1) == 'O' && rows[2].charAt(2) == 'O') {
                poseStack.m_85845_(Vector3f.f_122225_.m_122240_(45.0f));
                poseStack.m_85841_(1.0f, 1.0f, 5.2f);
                this.ticTacToeModel.m_7695_(poseStack, vertexconsumer, packedLight, packedOverlay, 0.0f, 0.0f, 0.0f, 1.0f);
            } else if (rows[0].charAt(2) == 'X' && rows[1].charAt(1) == 'X' && rows[2].charAt(0) == 'X' || rows[0].charAt(2) == 'O' && rows[1].charAt(1) == 'O' && rows[2].charAt(0) == 'O') {
                poseStack.m_85845_(Vector3f.f_122224_.m_122240_(45.0f));
                poseStack.m_85841_(1.0f, 1.0f, 5.2f);
                this.ticTacToeModel.m_7695_(poseStack, vertexconsumer, packedLight, packedOverlay, 0.0f, 0.0f, 0.0f, 1.0f);
            }
            poseStack.m_85849_();
        }
        String[] circleColor = blockEntity.getCircleColor().split("/");
        int[] rgb = new int[3];
        try {
            rgb[0] = Integer.parseInt(circleColor[0]);
            rgb[1] = Integer.parseInt(circleColor[1]);
            rgb[2] = Integer.parseInt(circleColor[2]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (int x = 0; x < rows.length; ++x) {
            for (int y = 0; y < 3; ++y) {
                char tileChar = rows[x].charAt(y);
                if (tileChar != 'O') continue;
                poseStack.m_85836_();
                poseStack.m_85837_((double)(0.6f * (float)(-(x - 1))), 0.0, 0.0);
                poseStack.m_85837_(0.0, 0.0, (double)(0.6f * (float)(-(y - 1))));
                if (blockEntity.getTicTacToeFrame(y + 3 * x) != -1) {
                    VertexConsumer vertexconsumer = bufferSource.m_6299_(RenderType.m_110452_((ResourceLocation)CIRCLE_TEXTURES.get(blockEntity.getTicTacToeFrame(y + 3 * x))));
                    this.ticTacToeModel.m_7695_(poseStack, vertexconsumer, packedLight, packedOverlay, (float)rgb[0] / 255.0f, (float)rgb[1] / 255.0f, (float)rgb[2] / 255.0f, 1.0f);
                }
                poseStack.m_85849_();
            }
        }
        String[] crossColor = blockEntity.getCrossColor().split("/");
        try {
            rgb[0] = Integer.parseInt(crossColor[0]);
            rgb[1] = Integer.parseInt(crossColor[1]);
            rgb[2] = Integer.parseInt(crossColor[2]);
        }
        catch (Exception y) {
            // empty catch block
        }
        for (int x = 0; x < rows.length; ++x) {
            for (int y = 0; y < 3; ++y) {
                char tileChar = rows[x].charAt(y);
                if (tileChar != 'X') continue;
                poseStack.m_85836_();
                poseStack.m_85837_((double)(0.6f * (float)(-(x - 1))), 0.0, 0.0);
                poseStack.m_85837_(0.0, 0.0, (double)(0.6f * (float)(-(y - 1))));
                poseStack.m_85845_(Vector3f.f_122224_.m_122240_(45.0f));
                if (blockEntity.getTicTacToeFrame(y + 3 * x) != -1 && blockEntity.getTicTacToeFrame(y + 3 * x) <= 13) {
                    VertexConsumer vertexconsumer = bufferSource.m_6299_(RenderType.m_110452_((ResourceLocation)CROSS_TEXTURES.get(blockEntity.getTicTacToeFrame(y + 3 * x))));
                    this.ticTacToeModel.m_7695_(poseStack, vertexconsumer, packedLight, packedOverlay, (float)rgb[0] / 255.0f, (float)rgb[1] / 255.0f, (float)rgb[2] / 255.0f, 1.0f);
                }
                poseStack.m_85849_();
            }
        }
        poseStack.m_85849_();
    }
}

