/*
 * Decompiled with CFR 0.152.
 */
package andrews.table_top_craft.util.obj;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec2;
import org.apache.commons.compress.utils.IOUtils;

public class ObjModel {
    private final Vector3f[] v;
    private final Vec2[] vt;
    private final Vector3f[] vn;
    private final Face[] faces;

    private ObjModel(Vector3f[] v, Vec2[] vt, Vector3f[] vn, Face[] faces) {
        this.v = v;
        this.vt = vt;
        this.vn = vn;
        this.faces = faces;
    }

    public void render(PoseStack stack, VertexConsumer buffer) {
        try {
            for (Face face : this.faces) {
                Vector3f v1 = this.v[face.v1 - 1];
                Vector3f v2 = this.v[face.v2 - 1];
                Vector3f v3 = this.v[face.v3 - 1];
                Vec2 vt1 = this.vt[face.vt1 - 1];
                Vec2 vt2 = this.vt[face.vt2 - 1];
                Vec2 vt3 = this.vt[face.vt3 - 1];
                Vector3f vn1 = this.vn[face.vn1 - 1];
                Vector3f vn2 = this.vn[face.vn2 - 1];
                Vector3f vn3 = this.vn[face.vn3 - 1];
                this.addVertex(stack, buffer, v1.m_122239_(), v1.m_122260_(), v1.m_122269_(), vt1.f_82470_, -vt1.f_82471_, vn1.m_122239_(), vn1.m_122260_(), vn1.m_122269_());
                this.addVertex(stack, buffer, v2.m_122239_(), v2.m_122260_(), v2.m_122269_(), vt2.f_82470_, -vt2.f_82471_, vn2.m_122239_(), vn2.m_122260_(), vn2.m_122269_());
                this.addVertex(stack, buffer, v3.m_122239_(), v3.m_122260_(), v3.m_122269_(), vt3.f_82470_, -vt3.f_82471_, vn3.m_122239_(), vn3.m_122260_(), vn3.m_122269_());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addVertex(PoseStack stack, VertexConsumer builder, float x, float y, float z, float u, float v, float nx, float ny, float nz) {
        ObjModel.pos(builder, stack.m_85850_().m_85861_(), x, y, z).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(u, v).m_7120_(15, 15);
        ObjModel.normal(builder, stack.m_85850_().m_85864_(), nx, ny, nz).m_5752_();
    }

    private static VertexConsumer pos(VertexConsumer bufferBuilder, Matrix4f matrix4f, float x, float y, float z) {
        float w = 1.0f;
        float tx = matrix4f.f_27603_ * x + matrix4f.f_27604_ * y + matrix4f.f_27605_ * z + matrix4f.f_27606_ * w;
        float ty = matrix4f.f_27607_ * x + matrix4f.f_27608_ * y + matrix4f.f_27609_ * z + matrix4f.f_27610_ * w;
        float tz = matrix4f.f_27611_ * x + matrix4f.f_27612_ * y + matrix4f.f_27613_ * z + matrix4f.f_27614_ * w;
        return bufferBuilder.m_5483_((double)tx, (double)ty, (double)tz);
    }

    private static VertexConsumer normal(VertexConsumer bufferBuilder, Matrix3f matrix3f, float x, float y, float z) {
        float nx = matrix3f.f_8134_ * x + matrix3f.f_8135_ * y + matrix3f.f_8136_ * z;
        float ny = matrix3f.f_8137_ * x + matrix3f.f_8138_ * y + matrix3f.f_8139_ * z;
        float nz = matrix3f.f_8140_ * x + matrix3f.f_8141_ * y + matrix3f.f_8142_ * z;
        return bufferBuilder.m_5601_(nx, ny, nz);
    }

    public static ObjModel loadModel(ResourceLocation resourceLocation) {
        byte[] modelData = ObjModel.loadResource(resourceLocation);
        String modelString = new String(modelData);
        String[] modelLines = modelString.split("\\r?\\n");
        ArrayList<Vector3f> vList = new ArrayList<Vector3f>();
        ArrayList<Vec2> vtList = new ArrayList<Vec2>();
        ArrayList<Vector3f> vnList = new ArrayList<Vector3f>();
        ArrayList<Face> faceList = new ArrayList<Face>();
        for (String line : modelLines) {
            String[] lineSpit = line.split(" ");
            if (lineSpit[0].equals("v")) {
                vList.add(new Vector3f(Float.parseFloat(lineSpit[1]), Float.parseFloat(lineSpit[2]), Float.parseFloat(lineSpit[3])));
            }
            if (lineSpit[0].equals("vt")) {
                vtList.add(new Vec2(Float.parseFloat(lineSpit[1]), Float.parseFloat(lineSpit[2])));
            }
            if (lineSpit[0].equals("vn")) {
                vnList.add(new Vector3f(Float.parseFloat(lineSpit[1]), Float.parseFloat(lineSpit[2]), Float.parseFloat(lineSpit[3])));
            }
            if (!lineSpit[0].equals("f")) continue;
            faceList.add(new Face(lineSpit[1], lineSpit[2], lineSpit[3]));
        }
        Vector3f[] vArray = vList.toArray(new Vector3f[vList.size()]);
        Vec2[] vtArray = vtList.toArray(new Vec2[vtList.size()]);
        Vector3f[] vnArray = vnList.toArray(new Vector3f[vnList.size()]);
        Face[] faces = faceList.toArray(new Face[faceList.size()]);
        return new ObjModel(vArray, vtArray, vnArray, faces);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] loadResource(ResourceLocation resourceLocation) {
        ByteArrayOutputStream output;
        InputStream input;
        block4: {
            byte[] byArray;
            input = null;
            output = null;
            try {
                input = ObjModel.class.getClassLoader().getResourceAsStream("assets/table_top_craft/" + resourceLocation.m_135815_());
                if (input == null) break block4;
                output = new ByteArrayOutputStream();
                IOUtils.copy((InputStream)input, (OutputStream)output);
                output.flush();
                byArray = output.toByteArray();
            }
            catch (IOException e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(input);
                    IOUtils.closeQuietly(output);
                    throw throwable;
                }
                IOUtils.closeQuietly((Closeable)input);
                IOUtils.closeQuietly(output);
            }
            IOUtils.closeQuietly((Closeable)input);
            IOUtils.closeQuietly((Closeable)output);
            return byArray;
        }
        IOUtils.closeQuietly((Closeable)input);
        IOUtils.closeQuietly((Closeable)output);
        return null;
    }

    private static class Face {
        public int v1;
        public int v2;
        public int v3;
        public int vt1;
        public int vt2;
        public int vt3;
        public int vn1;
        public int vn2;
        public int vn3;

        public Face(String v1, String v2, String v3) {
            String[] s1 = v1.split("/");
            String[] s2 = v2.split("/");
            String[] s3 = v3.split("/");
            this.v1 = Integer.parseInt(s1[0]);
            this.vt1 = Integer.parseInt(s1[1]);
            this.vn1 = Integer.parseInt(s1[2]);
            this.v2 = Integer.parseInt(s2[0]);
            this.vt2 = Integer.parseInt(s2[1]);
            this.vn2 = Integer.parseInt(s2[2]);
            this.v3 = Integer.parseInt(s3[0]);
            this.vt3 = Integer.parseInt(s3[1]);
            this.vn3 = Integer.parseInt(s3[2]);
        }
    }
}

